/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.keystore;

import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreFactory;
import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreType;
import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import javax.crypto.BadPaddingException;
import org.apache.log4j.Logger;

public abstract class AbstractKeyStoreFactory
implements KeyStoreFactory {
    private static final Logger log = Logger.getLogger(AbstractKeyStoreFactory.class);
    private static final String JDK_TRUSTSTORE_LOCATION = String.valueOf(System.getProperty("java.home")) + "/lib/security/cacerts";
    private volatile KeyStore truststoreFromJDK = null;
    private final Object truststoreFromJDKLock = new Object();

    @Override
    public KeyStore create(KeyStoreType keyStoreType, InputStream keyStoreStream, String keyStorePassword) throws UnrecoverableKeyException, BadPaddingException {
        try {
            return KeyStoreUtil.create(keyStoreType, keyStoreStream, keyStorePassword);
        }
        catch (GeneralSecurityException ex) {
            throw this.logAndCreateIllegalStateException(ex, "Keystore cannot be created");
        }
        catch (IOException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)cause;
            }
            if (cause instanceof BadPaddingException) {
                throw (BadPaddingException)cause;
            }
            throw this.logAndCreateIllegalStateException(ex, "Keystore cannot be created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final KeyStore createJDKTruststore() {
        if (this.truststoreFromJDK == null) {
            Object object = this.truststoreFromJDKLock;
            synchronized (object) {
                if (this.truststoreFromJDK == null) {
                    this.loadJDKTrustStore();
                }
            }
        }
        return this.truststoreFromJDK;
    }

    private void loadJDKTrustStore() {
        try {
            FileInputStream jdkTrustStoreStream = new FileInputStream(JDK_TRUSTSTORE_LOCATION);
            this.truststoreFromJDK = this.create(KeyStoreType.JKS, jdkTrustStoreStream, null);
        }
        catch (Exception ex) {
            throw this.logAndCreateIllegalStateException(ex, "JDK keystore cannot be created");
        }
    }

    protected final IllegalStateException logAndCreateIllegalStateException(Exception ex, String errorMessage) {
        log.error((Object)errorMessage, (Throwable)ex);
        return new IllegalStateException(errorMessage);
    }
}

