/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.keystore;

import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreType;
import com.sap.core.connectivity.apiext.validation.validators.consts.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class KeyStoreUtil {
    private static final Logger log = Logger.getLogger(KeyStoreUtil.class);
    private static final String CERTIFICATE_ALIAS = "alias";
    public static final Set<String> ALLOWED_JKS_EXTESIONS;
    public static final Set<String> ALLOWED_PKCS12_EXTESIONS;
    public static final Set<String> ALLOWED_CERTIFICATE_EXTESIONS;
    public static final Set<String> ALLOWED_KEYSTORE_EXTESIONS;
    public static final Set<String> ALLOWED_TRUSTSTORE_EXTESIONS;
    public static final Set<String> ALLOWED_EXTESIONS;

    static {
        ALLOWED_KEYSTORE_EXTESIONS = CommonConstants.allowedKeyStoreExtensions;
        ALLOWED_TRUSTSTORE_EXTESIONS = CommonConstants.allowedTrustStoreExtensions;
        HashSet allowedJKSExtensions = new HashSet();
        Collections.addAll(allowedJKSExtensions, "jks");
        ALLOWED_JKS_EXTESIONS = Collections.unmodifiableSet(allowedJKSExtensions);
        HashSet allowedPKCS12Extensions = new HashSet();
        Collections.addAll(allowedPKCS12Extensions, "p12", "pfx");
        ALLOWED_PKCS12_EXTESIONS = Collections.unmodifiableSet(allowedPKCS12Extensions);
        HashSet allowedCertificateExtensions = new HashSet();
        Collections.addAll(allowedCertificateExtensions, "crt", "cer", "der");
        ALLOWED_CERTIFICATE_EXTESIONS = Collections.unmodifiableSet(allowedCertificateExtensions);
        HashSet<String> alllowedExtensions = new HashSet<String>();
        alllowedExtensions.addAll(ALLOWED_KEYSTORE_EXTESIONS);
        alllowedExtensions.addAll(ALLOWED_TRUSTSTORE_EXTESIONS);
        ALLOWED_EXTESIONS = Collections.unmodifiableSet(alllowedExtensions);
    }

    public static KeyStoreType getTypeByExtension(String keyStoreExtension) {
        if (keyStoreExtension != null) {
            String lowerCaseExtension = keyStoreExtension.toLowerCase();
            if (ALLOWED_JKS_EXTESIONS.contains(lowerCaseExtension)) {
                return KeyStoreType.JKS;
            }
            if (ALLOWED_PKCS12_EXTESIONS.contains(lowerCaseExtension)) {
                return KeyStoreType.PKCS12;
            }
            if (ALLOWED_CERTIFICATE_EXTESIONS.contains(lowerCaseExtension)) {
                return KeyStoreType.CERT;
            }
        }
        return null;
    }

    public static KeyStoreType getTypeByPath(String keyStorePath) {
        String keyStoreExtension = KeyStoreUtil.getExtension(keyStorePath);
        return KeyStoreUtil.getTypeByExtension(keyStoreExtension);
    }

    private static String getExtension(String keyStorePath) {
        File keyStoreFile;
        String keyStoreName;
        int extensionIdx;
        String keyStoreExtension = null;
        if (keyStorePath != null && (extensionIdx = (keyStoreName = (keyStoreFile = new File(keyStorePath)).getName()).lastIndexOf(".") + 1) > 0 && extensionIdx < keyStoreName.length()) {
            keyStoreExtension = keyStoreName.substring(extensionIdx).toLowerCase();
        }
        return keyStoreExtension;
    }

    public static KeyStore create(KeyStoreType keyStoreType, InputStream keyStoreStream, String keyStorePassword) throws IOException, GeneralSecurityException {
        if (keyStoreType == KeyStoreType.CERT) {
            return KeyStoreUtil.createKeyStoreFromCert(keyStoreStream, keyStorePassword);
        }
        return KeyStoreUtil.createKeyStore(keyStoreType, keyStoreStream, keyStorePassword);
    }

    private static KeyStore createKeyStoreFromCert(InputStream keyStoreStream, String keyStorePassword) throws IOException, GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStoreUtil.createKeyStore(KeyStoreType.JKS, null, keyStorePassword);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(keyStoreStream);
            keyStore.setCertificateEntry(CERTIFICATE_ALIAS, certificate);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        finally {
            try {
                if (keyStoreStream != null) {
                    keyStoreStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    private static KeyStore createKeyStore(KeyStoreType keyStoreType, InputStream keyStoreStream, String keyStorePassword) throws IOException, GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType.name());
            if (keyStorePassword == null || keyStorePassword.isEmpty()) {
                keyStore.load(keyStoreStream, null);
            } else {
                keyStore.load(keyStoreStream, keyStorePassword.toCharArray());
            }
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        finally {
            try {
                if (keyStoreStream != null) {
                    keyStoreStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    public static KeyStore clone(KeyStore keyStore, String password) throws IOException, GeneralSecurityException {
        String type = keyStore.getType().toUpperCase();
        KeyStoreType keyStoreType = KeyStoreType.valueOf(type);
        ByteArrayOutputStream keyStoreOutputStream = new ByteArrayOutputStream();
        try {
            keyStore.store(keyStoreOutputStream, "".toCharArray());
            ByteArrayInputStream keyStoreInputStream = new ByteArrayInputStream(keyStoreOutputStream.toByteArray());
            KeyStore keyStore2 = KeyStoreUtil.createKeyStore(keyStoreType, keyStoreInputStream, password);
            return keyStore2;
        }
        finally {
            try {
                keyStoreOutputStream.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    public static KeyStore mergeTrustStores(KeyStore trustStore1, KeyStore trustStore2) throws IOException, GeneralSecurityException {
        KeyStore trustStore = KeyStoreUtil.clone(trustStore1, null);
        Enumeration<String> aliases = trustStore2.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate certificate = trustStore2.getCertificate(alias);
            if (certificate == null) continue;
            String uniqueAlias = KeyStoreUtil.convertToKeystoreUniqueAlias(trustStore, alias);
            trustStore.setCertificateEntry(uniqueAlias, certificate);
        }
        return trustStore;
    }

    private static String convertToKeystoreUniqueAlias(KeyStore keyStore, String alias) throws KeyStoreException {
        if (keyStore.containsAlias(alias)) {
            int counter = 0;
            String newAlias = String.valueOf(alias) + counter;
            while (keyStore.containsAlias(newAlias)) {
                newAlias = String.valueOf(alias) + ++counter;
            }
            return newAlias;
        }
        return alias;
    }
}

