/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.ldap;

import com.sap.core.connectivity.apiext.impl.configuration.PropertiesUtil;
import com.sap.core.connectivity.apiext.validation.validators.ldap.consts.LdapConstants;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LdapDestinationUtil {
    private static final Logger log = Logger.getLogger(LdapDestinationUtil.class);

    public static boolean isLdapDestination(Properties destinationProperties) {
        return "LDAP".equals(destinationProperties.getProperty("Type"));
    }

    public static Properties convertToLDAPContextProperties(Properties destinationProperties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing LDAP properties for destination: " + destinationProperties.getProperty("Name")));
        }
        Properties enhancedProps = PropertiesUtil.copyProperties(destinationProperties);
        String ldapUrl = enhancedProps.getProperty("ldap.url");
        if (enhancedProps.containsKey("CloudConnectorLocationId") && "OnPremise".equals(enhancedProps.getProperty("ldap.proxyType"))) {
            try {
                String locationId = enhancedProps.getProperty("CloudConnectorLocationId");
                URI ldapUri = new URI(ldapUrl);
                String locationIdHost = String.valueOf(locationId) + "@" + ldapUri.getHost();
                URI enhancedUri = new URI(ldapUri.getScheme(), ldapUri.getUserInfo(), locationIdHost, ldapUri.getPort(), ldapUri.getPath(), ldapUri.getQuery(), ldapUri.getFragment());
                String locationIdUrl = enhancedUri.toString().replace(locationIdHost, String.valueOf(locationId) + "^" + ldapUri.getHost());
                enhancedProps.setProperty("ldap.url", locationIdUrl);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Invalid uri: ", (Throwable)e);
            }
        }
        LdapConstants.DirContextProperty[] dirContextPropertyArray = LdapConstants.DirContextProperty.values();
        int n = dirContextPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            LdapConstants.DirContextProperty dirContextProperty = dirContextPropertyArray[n2];
            if (dirContextProperty.isMandatory(enhancedProps)) {
                String dirContextValue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Calculating LDAP DirContext for destination: " + destinationProperties.getProperty("Name")));
                }
                if ((dirContextValue = dirContextProperty.calculateDirContextValue(enhancedProps)) != null) {
                    enhancedProps.put(dirContextProperty.key(), dirContextValue);
                } else {
                    throw new IllegalArgumentException("Mandatory LDAP context property " + dirContextProperty + " cannot be calculated based on provided properties.");
                }
            }
            ++n2;
        }
        enhancedProps.setProperty("ldap.url", ldapUrl);
        return enhancedProps;
    }
}

