/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.sappassport;

import com.sap.core.connectivity.api.sappassport.ConnectionInfo;
import com.sap.core.connectivity.api.sappassport.SapPassportHeader;
import com.sap.core.connectivity.api.sappassport.SapPassportHeaderProvider;
import com.sap.core.connectivity.apiext.impl.sappassport.SapPassportHeaderImpl;
import com.sap.core.connectivity.apiext.impl.sappassport.SapPassportProvider;
import com.sap.core.connectivity.apiext.impl.util.Environment;
import com.sap.core.connectivity.apiext.impl.util.JavaServiceLoader;
import com.sap.jdsr.util.ConvertHelper;
import com.sap.jdsr.writer.DsrIPassport;
import com.sap.js.statistics.api.providers.PassportProvider;
import org.apache.log4j.Logger;

public class SapPassportHeaderProviderImpl
implements SapPassportHeaderProvider {
    private static final Logger log = Logger.getLogger(SapPassportHeaderProviderImpl.class);
    private static final String SAP_PASSPORT_HEADER_KEY = "SAP-PASSPORT";
    private PassportProvider passportProvider;

    public SapPassportHeader getSapPassportHeader(ConnectionInfo connectionInfo) {
        SapPassportProvider sapPassportProvider;
        DsrIPassport dsrPassport;
        PassportProvider passportProvider = this.getPassportProvider();
        if (passportProvider != null && (dsrPassport = (sapPassportProvider = new SapPassportProvider(passportProvider)).getSapPassport(connectionInfo)) != null) {
            return new SapPassportHeaderImpl(SAP_PASSPORT_HEADER_KEY, this.convertDSRPassportToString(dsrPassport));
        }
        return null;
    }

    private String convertDSRPassportToString(DsrIPassport dsrPassport) {
        return ConvertHelper.byteArrayToHex((byte[])dsrPassport.getNetPassport());
    }

    private PassportProvider getPassportProvider() {
        if (this.passportProvider == null && !Environment.isOSGi()) {
            this.passportProvider = JavaServiceLoader.load(PassportProvider.class, this.getClass().getClassLoader());
        }
        if (this.passportProvider == null && log.isDebugEnabled()) {
            log.debug((Object)"PassportProvider service is not available");
        }
        return this.passportProvider;
    }

    protected void setPassportProvider(PassportProvider passportProvider) {
        this.passportProvider = passportProvider;
    }

    protected void unsetPassportProvider(PassportProvider passportProvider) {
        this.passportProvider = null;
    }
}

