/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.sappassport;

import com.sap.core.connectivity.api.sappassport.ConnectionInfo;
import com.sap.jdsr.passport.DSRPassport;
import com.sap.jdsr.writer.DsrIPassport;
import com.sap.js.statistics.api.providers.PassportProvider;
import org.apache.log4j.Logger;

public class SapPassportProvider {
    private static final Logger log = Logger.getLogger(SapPassportProvider.class);
    private static final String COMPONENT_NAME = String.valueOf(System.getenv("HC_REGION")) + ":" + System.getenv("HC_ACCOUNT") + ":" + System.getenv("HC_APPLICATION");
    private final PassportProvider passportProvider;

    public SapPassportProvider(PassportProvider passportProvider) {
        this.passportProvider = passportProvider;
    }

    public DsrIPassport getSapPassport(ConnectionInfo connectionInfo) {
        DsrIPassport oldPassport = this.passportProvider.getPassport();
        if (oldPassport != null) {
            return new DSRPassport(3, oldPassport.getTraceFlag(), oldPassport.getCompName(), oldPassport.getService(), oldPassport.getUserId(), oldPassport.getAction(), oldPassport.getActionType(), COMPONENT_NAME, oldPassport.getTransId(), oldPassport.getClientNumber(), oldPassport.getSystemType(), oldPassport.getRootContextIdBytes(), connectionInfo.getId(), connectionInfo.getCounter());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No SAP-PASSPORT was available from statitstics API.");
        }
        return null;
    }
}

