/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.ssl;

import com.sap.core.connectivity.apiext.impl.util.IPAddressUtil;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.log4j.Logger;

public class BrowserCompatibleHostnameVerifier
implements HostnameVerifier {
    private static final String RDN_TYPE_CN = "CN";
    private static final int ALTERNATIVE_NAME_TYPE_DNS = 2;
    private static final int ALTERNATIVE_NAME_TYPE_IPADDRESS = 7;
    private static final String[] BAD_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
    private static final Logger log = Logger.getLogger(BrowserCompatibleHostnameVerifier.class);

    static {
        Arrays.sort(BAD_2LDS);
    }

    protected static boolean acceptableWildcard(String[] templateParts) {
        if (templateParts.length != 3 || templateParts[2].length() != 2) {
            return true;
        }
        return Arrays.binarySearch(BAD_2LDS, templateParts[1]) < 0;
    }

    @Override
    public boolean verify(String hostname, SSLSession sslSession) {
        try {
            Certificate[] certificates = sslSession.getPeerCertificates();
            return this.verify(hostname, (X509Certificate)certificates[0]);
        }
        catch (SSLPeerUnverifiedException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Peer's identity has not been verified", (Throwable)ex);
            }
            return false;
        }
    }

    protected boolean verify(String hostname, X509Certificate certificate) {
        LinkedList<String> commonNames = this.getCommonNames(certificate);
        LinkedList<String> templateNames = this.getAlternativeNames(certificate, this.getAlternativeNameType(hostname));
        if (!commonNames.isEmpty()) {
            templateNames.addFirst(commonNames.getFirst());
        }
        return this.verify(hostname, templateNames);
    }

    protected boolean verify(String hostname, List<String> templateNames) {
        if (templateNames != null) {
            for (String templateName : templateNames) {
                if (!this.match(hostname, templateName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean match(String hostname, String templateName) {
        boolean match = false;
        String host = hostname.toLowerCase();
        String template = templateName.toLowerCase();
        String[] templateParts = template.split("\\.");
        if (!IPAddressUtil.isIPAddress(host) && BrowserCompatibleHostnameVerifier.acceptableWildcard(templateParts) && templateParts.length > 2 && templateParts[0].endsWith("*")) {
            if (templateParts[0].length() > 1) {
                String templatePrefix = templateParts[0].substring(0, templateParts[0].length() - 1);
                String templateSuffix = template.substring(templateParts[0].length());
                match = host.startsWith(templatePrefix) && host.substring(templatePrefix.length()).endsWith(templateSuffix);
            } else {
                match = host.endsWith(template.substring(1));
            }
        } else {
            match = host.equals(template);
        }
        return match;
    }

    private int getAlternativeNameType(String hostname) {
        return IPAddressUtil.isIPAddress(hostname) ? 7 : 2;
    }

    private LinkedList<String> getCommonNames(X509Certificate certificate) {
        LinkedList<String> commonNames;
        block3: {
            commonNames = new LinkedList<String>();
            try {
                String dn = certificate.getSubjectX500Principal().getName();
                LdapName ldapDN = new LdapName(dn);
                for (Rdn rdn : ldapDN.getRdns()) {
                    if (!RDN_TYPE_CN.equalsIgnoreCase(rdn.getType()) || !(rdn.getValue() instanceof String)) continue;
                    commonNames.add((String)rdn.getValue());
                }
            }
            catch (InvalidNameException ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Distinguished name is not formatted according to RFC 2253", (Throwable)ex);
            }
        }
        return commonNames;
    }

    private LinkedList<String> getAlternativeNames(X509Certificate certificate, int altNameType) {
        LinkedList<String> altNames;
        block4: {
            altNames = new LinkedList<String>();
            try {
                Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
                if (subjectAltNames != null) {
                    for (List<?> subjectAltName : subjectAltNames) {
                        int subjectAltNameType = (Integer)subjectAltName.get(0);
                        if (subjectAltNameType != altNameType) continue;
                        altNames.add((String)subjectAltName.get(1));
                    }
                }
            }
            catch (CertificateParsingException ex) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Certificate extension cannot be decoded", (Throwable)ex);
            }
        }
        return altNames;
    }
}

