/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.X509TrustManager;

public class TrustMultipleTrustStoreManager
implements X509TrustManager {
    private final X509TrustManager[] trustManagers;

    public TrustMultipleTrustStoreManager(X509TrustManager ... trustManagers) {
        if (trustManagers == null) {
            throw new IllegalArgumentException("Trust mangers can not be null");
        }
        this.trustManagers = trustManagers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean isclientTrusted = false;
        CertificateException thrownError = null;
        X509TrustManager[] x509TrustManagerArray = this.trustManagers;
        int n = this.trustManagers.length;
        int n2 = 0;
        while (n2 < n) {
            X509TrustManager trustManager = x509TrustManagerArray[n2];
            if (trustManager != null) {
                try {
                    trustManager.checkClientTrusted(chain, authType);
                    isclientTrusted = true;
                    break;
                }
                catch (CertificateException ex) {
                    thrownError = ex;
                }
            }
            ++n2;
        }
        if (!isclientTrusted && thrownError != null) {
            throw thrownError;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean isclientTrusted = false;
        CertificateException thrownError = null;
        X509TrustManager[] x509TrustManagerArray = this.trustManagers;
        int n = this.trustManagers.length;
        int n2 = 0;
        while (n2 < n) {
            X509TrustManager trustManager = x509TrustManagerArray[n2];
            if (trustManager != null) {
                try {
                    trustManager.checkServerTrusted(chain, authType);
                    isclientTrusted = true;
                    break;
                }
                catch (CertificateException ex) {
                    thrownError = ex;
                }
            }
            ++n2;
        }
        if (!isclientTrusted && thrownError != null) {
            throw thrownError;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> issuersList = new ArrayList<X509Certificate>();
        X509Certificate[] accepCertificates = null;
        X509TrustManager[] x509TrustManagerArray = this.trustManagers;
        int n = this.trustManagers.length;
        int n2 = 0;
        while (n2 < n) {
            X509TrustManager trustManager = x509TrustManagerArray[n2];
            if (trustManager != null && (accepCertificates = trustManager.getAcceptedIssuers()) != null) {
                issuersList.addAll(Arrays.asList(accepCertificates));
            }
            ++n2;
        }
        if (!issuersList.isEmpty()) {
            return issuersList.toArray(new X509Certificate[0]);
        }
        return null;
    }
}

