/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.util;

import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class IPAddressUtil {
    private static final Pattern PATTERN_IPV4_ADDRESS = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern PATTERN_IPV6_STANDARD_ADDRESS = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:)*[0-9a-fA-F]{1,4}$");
    private static final Pattern PATTERN_IPV6_COMPRESSED_ADDRESS = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private static final int IPV6_COMPONENT_COUNT = 8;
    private static final int IPV4_EMBEDDED_IPV6_COMPONENT_COUNT = 6;
    private static final char IPV6_COMPONENT_SEPARATOR = ':';
    private static final char IPV6_ZONE_SEPARATOR = '%';

    public static boolean isIPAddress(String host) {
        return IPAddressUtil.isIPv4Address(host) || IPAddressUtil.isIPv6Address(host);
    }

    public static boolean isIPv4Address(String host) {
        return IPAddressUtil.matchesIPv4Pattern(host);
    }

    public static boolean isIPv6Address(String host) {
        return IPAddressUtil.isIPv6StandardAddress(host) || IPAddressUtil.isIPv6CompressedAddress(host) || IPAddressUtil.isIPv4EmbeddedIPv6Address(host);
    }

    public static boolean isIPv6StandardAddress(String host) {
        return IPAddressUtil.matchesIPv6StandardPattern(IPAddressUtil.extractIPV6Host(host), 8);
    }

    public static boolean isIPv6CompressedAddress(String host) {
        return IPAddressUtil.matchesIPv6CompressedPattern(IPAddressUtil.extractIPV6Host(host), 8);
    }

    public static boolean isIPv4EmbeddedIPv6Address(String host) {
        return IPAddressUtil.matchesIPv4EmbeddedIPv6Pattern(IPAddressUtil.extractIPV6Host(host));
    }

    private static boolean matchesIPv4Pattern(String host) {
        return host != null && PATTERN_IPV4_ADDRESS.matcher(host).matches();
    }

    private static boolean matchesIPv6Pattern(String host, int componentCount) {
        return IPAddressUtil.matchesIPv6StandardPattern(host, componentCount) || IPAddressUtil.matchesIPv6CompressedPattern(host, componentCount);
    }

    private static boolean matchesIPv6StandardPattern(String host, int componentCount) {
        boolean match = false;
        if (host != null) {
            StringTokenizer tokenizer = new StringTokenizer(host, String.valueOf(':'));
            match = PATTERN_IPV6_STANDARD_ADDRESS.matcher(host).matches() && tokenizer.countTokens() == componentCount;
        }
        return match;
    }

    private static boolean matchesIPv6CompressedPattern(String host, int componentCount) {
        boolean match = false;
        if (host != null) {
            int maxComponentCount = componentCount - 2;
            StringTokenizer tokenizer = new StringTokenizer(host, String.valueOf(':'));
            match = PATTERN_IPV6_COMPRESSED_ADDRESS.matcher(host).matches() && tokenizer.countTokens() <= maxComponentCount;
        }
        return match;
    }

    private static boolean matchesIPv4EmbeddedIPv6Pattern(String host) {
        int separator;
        boolean match = false;
        if (host != null && (separator = host.lastIndexOf(58)) > -1) {
            int ipv4BeginIndex = separator + 1;
            int ipv6EndIndex = separator > 0 && host.charAt(separator - 1) == ':' ? separator + 1 : separator;
            match = IPAddressUtil.matchesIPv4Pattern(host.substring(ipv4BeginIndex)) && IPAddressUtil.matchesIPv6Pattern(host.substring(0, ipv6EndIndex), 6);
        }
        return match;
    }

    private static String extractIPV6Host(String host) {
        int zoneSeparator;
        String ipv6Host = host;
        if (host != null && (zoneSeparator = host.lastIndexOf(37)) > -1) {
            ipv6Host = host.substring(0, zoneSeparator);
        }
        return ipv6Host;
    }
}

