/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.util;

import com.sap.core.connectivity.apiext.impl.configuration.PropertiesUtil;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OnPremiseDestinationUtil {
    private static final Logger log = Logger.getLogger(OnPremiseDestinationUtil.class);

    public static boolean isOnPremiseDestination(Properties destinationProperties) {
        return "OnPremise".equals(destinationProperties.getProperty("ProxyType"));
    }

    public static Properties convertOnPremiseDestinationURLProperties(Properties destinationProperties) {
        boolean isHttpsOAuthURLPrefix;
        if (!OnPremiseDestinationUtil.isOnPremiseDestination(destinationProperties)) {
            throw new IllegalArgumentException("The ProxyType passed is not OnPremise!");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing OnPremise properties for destination: " + destinationProperties.getProperty("Name")));
        }
        Properties enhancedProperties = destinationProperties;
        String destURL = enhancedProperties.getProperty("URL");
        String oAuthURL = enhancedProperties.getProperty("tokenServiceURL");
        boolean isHttpsDestURLPrefix = destURL != null && destURL.startsWith("https://");
        boolean bl = isHttpsOAuthURLPrefix = oAuthURL != null && oAuthURL.startsWith("https://");
        if (isHttpsDestURLPrefix || isHttpsOAuthURLPrefix) {
            enhancedProperties = PropertiesUtil.copyProperties(destinationProperties);
            if (isHttpsDestURLPrefix) {
                String onPremiseDestURL = destURL.replaceFirst("https://", "http://");
                enhancedProperties.setProperty("URL", onPremiseDestURL);
            }
            if (isHttpsOAuthURLPrefix) {
                String onPremiseOAuthURL = oAuthURL.replaceFirst("https://", "http://");
                enhancedProperties.setProperty("tokenServiceURL", onPremiseOAuthURL);
            }
        }
        return enhancedProperties;
    }
}

