/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.util;

import com.sap.core.connectivity.apiext.impl.util.UriFactory;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class UriConverter {
    private Logger log = Logger.getLogger(UriConverter.class);

    public URI convert(URI requestURI, String destUrlStr, boolean check) throws URISyntaxException {
        return this.convert(requestURI, new URI(destUrlStr), check);
    }

    public URI convert(URI requestURI, URI destURI, boolean check) throws URISyntaxException {
        if (requestURI != null) {
            String requestPath = requestURI.getRawPath();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Will convert request path: " + requestPath));
            }
            String destUrlPath = destURI.getRawPath();
            if (check) {
                this.check(requestURI, destURI);
            }
            if (requestPath == null || destUrlPath == null) {
                throw new URISyntaxException(requestURI.toString(), "URIs defined in destination '" + destURI + "' and supplied by application code '" + requestURI + "' cannot be concatenated");
            }
            requestPath = this.concatenateURLPaths(destUrlPath, requestPath);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Converted request path: " + requestPath));
            }
            return UriFactory.create(destURI.getScheme(), requestURI.getRawUserInfo(), destURI.getHost(), destURI.getPort(), requestPath, requestURI.getRawQuery(), requestURI.getRawFragment());
        }
        String requestPath = destURI.getRawPath();
        requestPath = requestPath.replaceAll("^/", "");
        requestPath = "/" + requestPath;
        return UriFactory.create(destURI.getScheme(), destURI.getRawUserInfo(), destURI.getHost(), destURI.getPort(), requestPath, destURI.getRawQuery(), destURI.getRawFragment());
    }

    private void check(URI requestURI, URI destinationUri) throws URISyntaxException {
        if (requestURI.getHost() != null) {
            boolean isSchemeEqual = destinationUri.getScheme().equalsIgnoreCase(requestURI.getScheme());
            boolean isHostEqual = destinationUri.getHost().equalsIgnoreCase(requestURI.getHost());
            boolean isPortEqual = destinationUri.getPort() == requestURI.getPort();
            String destinationUriPath = destinationUri.getPath().endsWith("/") ? destinationUri.getPath().substring(0, destinationUri.getPath().length() - 1) : destinationUri.getPath();
            boolean requestPathStartsWithDestinationPath = requestURI.getPath().startsWith(destinationUriPath);
            if (!(isSchemeEqual && isHostEqual && isPortEqual && requestPathStartsWithDestinationPath)) {
                throw new URISyntaxException(requestURI.toString(), "URIs defined in destination '" + destinationUri + "' and supplied by application code '" + requestURI + "' differ");
            }
        }
    }

    private String concatenateURLPaths(String firstPath, String secondPath) {
        String firstTrimmed = firstPath.replaceAll("/$|^/", "");
        String secondTrimmed = secondPath.replaceAll("^/", "");
        if (secondPath.isEmpty()) {
            return firstPath;
        }
        if (secondTrimmed.startsWith(firstTrimmed)) {
            return "/" + secondTrimmed;
        }
        return "/" + firstTrimmed + "/" + secondTrimmed;
    }
}

