/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.validation;

import com.sap.core.connectivity.apiext.impl.datasource.object.DestinationConfigurationObject;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DestinationValidation {
    private final Validator validator;

    DestinationValidation(Validator validator) {
        this.validator = validator;
    }

    public String[] validate(DestinationConfigurationObject destinationConfiguration) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        Properties properties = DestinationValidation.trimProperties(destinationConfiguration.getProperties());
        this.checkEntries(properties, errorMessages);
        return errorMessages.toArray(new String[0]);
    }

    protected void checkEntries(Properties destinationProperties, List<String> errorMessages) {
        ViolationSet validationOutcome = this.validator.validate(destinationProperties);
        if (validationOutcome.hasErrors()) {
            for (Violation violation : validationOutcome.getErrors()) {
                errorMessages.add(violation.getMessage());
            }
        }
    }

    protected static boolean isValueEmpty(Properties destinationProperties, String key) {
        if (!destinationProperties.containsKey(key)) {
            return true;
        }
        String value = destinationProperties.getProperty(key);
        return value == null || value.isEmpty();
    }

    private static Properties trimProperties(Properties properties) {
        Properties result = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String trimmedValue = ((String)entry.getValue()).trim();
            if ("Type".equals(entry.getKey())) {
                trimmedValue = trimmedValue.toUpperCase();
            }
            result.put(entry.getKey(), trimmedValue);
        }
        return result;
    }

    public static enum DestinationType {
        HTTP("HTTP"),
        MAIL("MAIL"),
        RFC("RFC"),
        LDAP("LDAP");

        private static final Map<String, DestinationType> stringToEnum;
        private final String value;

        static {
            stringToEnum = new HashMap<String, DestinationType>();
            DestinationType[] destinationTypeArray = DestinationType.values();
            int n = destinationTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DestinationType destinationType = destinationTypeArray[n2];
                stringToEnum.put(destinationType.getValue(), destinationType);
                ++n2;
            }
        }

        private DestinationType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static DestinationType getType(String type) {
            if (type == null) {
                throw new IllegalArgumentException("The value of property Type must be configured.");
            }
            if (stringToEnum.containsKey(type.toUpperCase())) {
                return stringToEnum.get(type.toUpperCase());
            }
            throw new IllegalArgumentException(String.format("Destination with Type=%s is not found.", type));
        }

        public static String toList() {
            String allowedTypes = "";
            DestinationType[] types = DestinationType.values();
            int i = 0;
            while (i < types.length) {
                allowedTypes = allowedTypes.concat(types[i].toString());
                if (i < types.length - 1) {
                    allowedTypes = allowedTypes.concat(", ");
                }
                ++i;
            }
            return allowedTypes;
        }
    }
}

