/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.impl.validation;

import com.sap.core.connectivity.apiext.impl.validation.DestinationValidation;
import com.sap.core.connectivity.apiext.validation.DestinationValidatorFactory;
import com.sap.core.connectivity.apiext.validation.NotSupportedDestinationTypeException;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DestinationValidationFactory {
    private static final Map<DestinationValidation.DestinationType, DestinationValidation> destinationValidators = new ConcurrentHashMap<DestinationValidation.DestinationType, DestinationValidation>();

    public static DestinationValidation getDestinationValidation(DestinationValidation.DestinationType type) {
        DestinationValidationFactory.assertType(type);
        if (!destinationValidators.containsKey((Object)type)) {
            DestinationValidationFactory.registerDestinationValidation(type);
        }
        return destinationValidators.get((Object)type);
    }

    private static void assertType(DestinationValidation.DestinationType type) {
        if (type == null) {
            throw new IllegalArgumentException("Destination type is null");
        }
    }

    private static void registerDestinationValidation(DestinationValidation.DestinationType type) {
        try {
            Validator validator = DestinationValidatorFactory.getValidator((String)type.getValue());
            destinationValidators.put(type, new DestinationValidation(validator));
        }
        catch (NotSupportedDestinationTypeException ex) {
            throw new IllegalArgumentException("There is no validator for destination type: " + (Object)((Object)type), ex);
        }
    }
}

