/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.destinations.configuration;

import com.sap.core.connectivity.api.configuration.ConnectivityConfiguration;
import com.sap.core.connectivity.apiext.impl.configuration.AbstractConnectivityConfiguration;
import com.sap.core.connectivity.apiext.impl.configuration.AbstractDestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.configuration.ConfigurationLevel;
import com.sap.core.connectivity.destinations.configuration.ConfigurationProvider;
import com.sap.core.connectivity.destinations.configuration.DestinationConfiguration;
import com.sap.core.connectivity.destinations.configuration.DestinationConfigurationException;
import com.sap.core.connectivity.destinations.configuration.DestinationNotAvailableException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DestinationConfigurationProvider
implements ConfigurationProvider {
    private com.sap.core.connectivity.apiext.impl.configuration.provider.ConfigurationProvider configurationProvider;

    @Override
    public DestinationConfiguration getDestinationConfiguration(String name) throws DestinationConfigurationException {
        try {
            AbstractDestinationConfiguration destinationConfiguration = (AbstractDestinationConfiguration)this.configurationProvider.getDestinationConfiguration(name);
            return this.convertDestinationConfiguration(destinationConfiguration);
        }
        catch (com.sap.core.connectivity.apiext.impl.configuration.DestinationConfigurationException ex) {
            throw this.convertDestinationConfigurationException(ex);
        }
    }

    @Override
    public Map<String, DestinationConfiguration> getDestinationConfigurations() throws DestinationConfigurationException {
        try {
            Map<String, com.sap.core.connectivity.api.configuration.DestinationConfiguration> destinationConfigurations = this.configurationProvider.getDestinationConfigurations();
            HashMap<String, DestinationConfiguration> result = new HashMap<String, DestinationConfiguration>(destinationConfigurations.size());
            for (Map.Entry<String, com.sap.core.connectivity.api.configuration.DestinationConfiguration> destinationConfigurationEntry : destinationConfigurations.entrySet()) {
                AbstractDestinationConfiguration destinationConfiguration = (AbstractDestinationConfiguration)destinationConfigurationEntry.getValue();
                result.put(destinationConfigurationEntry.getKey(), this.convertDestinationConfiguration(destinationConfiguration));
            }
            return result;
        }
        catch (com.sap.core.connectivity.apiext.impl.configuration.DestinationConfigurationException ex) {
            throw this.convertDestinationConfigurationException(ex);
        }
    }

    @Override
    public KeyStore getKeyStore(String destinationName, String keyStorePath, String keyStorePass, String configurationLevel) throws DestinationConfigurationException {
        try {
            return this.configurationProvider.getKeyStore(destinationName, keyStorePath, keyStorePass, configurationLevel != null ? ConfigurationLevel.getValue(configurationLevel) : null);
        }
        catch (com.sap.core.connectivity.apiext.impl.configuration.DestinationConfigurationException ex) {
            throw this.convertDestinationConfigurationException(ex);
        }
    }

    private DestinationConfiguration convertDestinationConfiguration(AbstractDestinationConfiguration destinationConfiguration) {
        Properties properties = this.convertProperties(destinationConfiguration.getAllProperties());
        String configurationLevel = this.convertConfigurationLevel(destinationConfiguration.getConfigurationLevel());
        return new DestinationConfiguration(properties, configurationLevel);
    }

    private Properties convertProperties(Map<String, String> propertiesMap) {
        Properties properties = null;
        if (propertiesMap != null) {
            properties = new Properties();
            properties.putAll(propertiesMap);
        }
        return properties;
    }

    private String convertConfigurationLevel(ConfigurationLevel configurationLevel) {
        return configurationLevel != null ? configurationLevel.toString() : null;
    }

    private DestinationConfigurationException convertDestinationConfigurationException(com.sap.core.connectivity.apiext.impl.configuration.DestinationConfigurationException destinationConfigurationException) {
        if (destinationConfigurationException instanceof com.sap.core.connectivity.apiext.impl.configuration.DestinationNotAvailableException) {
            return new DestinationNotAvailableException(destinationConfigurationException.getMessage(), destinationConfigurationException.getCause());
        }
        return new DestinationConfigurationException(destinationConfigurationException.getMessage(), destinationConfigurationException.getCause());
    }

    protected void setConnectivityConfiguration(ConnectivityConfiguration connectivityConfiguration) {
        this.configurationProvider = ((AbstractConnectivityConfiguration)connectivityConfiguration).getConfigurationProvider();
    }

    protected void unsetConnectivityConfiguration(ConnectivityConfiguration connectivityConfiguration) {
        this.configurationProvider = null;
    }
}

