/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.destinations.configuration;

import com.sap.core.config.runtime.api.ConfigurationService;
import java.util.HashMap;
import java.util.Map;

public enum DestinationProviderEnum {
    FILESYSTEM("FileSystem"),
    SUBSCRIPTION("Subscription"),
    TENANT("Account"),
    APPLICATION("Application");

    private static final Map<String, DestinationProviderEnum> stringToEnum;
    private final String value;

    static {
        stringToEnum = new HashMap<String, DestinationProviderEnum>();
        stringToEnum.put(APPLICATION.toString(), APPLICATION);
    }

    private DestinationProviderEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static DestinationProviderEnum getValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null.");
        }
        if (stringToEnum.containsKey(value)) {
            return stringToEnum.get(value);
        }
        throw new IllegalArgumentException(String.format("DestinationProvider with value %s is not found.", value));
    }

    public ConfigurationService.ConfigurationLocation calculateConfigurationLocation() {
        ConfigurationService.ConfigurationLocation location = null;
        location = this.equals((Object)TENANT) ? ConfigurationService.ConfigurationLocation.TENANT : ConfigurationService.ConfigurationLocation.getValue((String)this.toString());
        return location;
    }

    public static DestinationProviderEnum getValueForKeystore(String configurationLevel) {
        if (configurationLevel.equals(APPLICATION.toString())) {
            return APPLICATION;
        }
        if (configurationLevel.equals(SUBSCRIPTION.toString())) {
            return SUBSCRIPTION;
        }
        if (configurationLevel.equals(TENANT.toString())) {
            return TENANT;
        }
        if (configurationLevel.equals(FILESYSTEM.toString())) {
            return FILESYSTEM;
        }
        throw new IllegalArgumentException(String.format("DestinationProvider with value %s is not found.", configurationLevel));
    }
}

