/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource;

import com.sap.ui5.resource.ResourceConfig;
import com.sap.ui5.resource.impl.ServletResourceConfig;
import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheControlFilter
implements Filter {
    private FilterConfig filterConfig = null;
    private ResourceConfig config = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.config = ServletResourceConfig.getInstance(this.filterConfig.getServletContext());
    }

    public void destroy() {
        this.config = null;
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.config.isUseCache(request) && response instanceof HttpServletResponse) {
            HttpServletResponse httpResonse = (HttpServletResponse)response;
            CacheControlFilter.addNoCacheHeaders(httpResonse);
            chain.doFilter(request, (ServletResponse)httpResonse);
        } else {
            chain.doFilter(request, response);
        }
    }

    public static void addNoCacheHeaders(HttpServletResponse response) {
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-cache, no-store");
    }

    public static void addHeaders(HttpServletResponse response, boolean useCache, long maxAge, long lastModified, int contentLength) {
        if (!useCache && lastModified > 0L) {
            response.setDateHeader("Expires", 0L);
            response.setHeader("Cache-Control", "must-revalidate");
            response.setDateHeader("Last-Modified", lastModified);
            if (lastModified > 0L && contentLength > -1) {
                response.setHeader("ETag", "W/\"" + contentLength + "-" + lastModified + "\"");
            }
        } else {
            if (maxAge == -1L) {
                maxAge = 315360000000L;
            }
            long expiresTime = new Date().getTime() + maxAge;
            response.setDateHeader("Expires", expiresTime);
            response.setHeader("Cache-Control", "max-age=" + maxAge / 1000L + ", public");
        }
    }

    public static boolean matchesETag(HttpServletRequest request, long lastModified, int contentLength) {
        String eTag = request.getHeader("If-None-Match");
        return ("W/\"" + contentLength + "-" + lastModified + "\"").equals(eTag);
    }
}

