/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource;

import com.sap.ui5.resource.util.FormatterUtil;
import com.sap.ui5.resource.util.XSSEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Resource {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String BASE_THEME_NAME = "base";
    private static final Pattern PATTERN_THEME_REQUEST = Pattern.compile("(.*/themes/)([^/]*)(/.*)");
    private static final Pattern PATTERN_PROPERTIES_REQUEST = Pattern.compile("(.*/)([^_]*)(_[^_]*)?(_.*)?\\.properties");
    private String name = null;
    private String path = null;
    private URL url = null;
    private boolean isFile = false;
    private long lastModified = -1L;
    private int contentLength = 0;
    private String contentEncoding = null;
    private String contentType = null;
    private Map<String, String> properties = null;

    public Resource(String path, URL url) {
        this.path = path;
        this.url = url;
        int indexOfSlash = -1;
        if (this.path.endsWith("/")) {
            indexOfSlash = this.path.lastIndexOf("/", this.path.length() - 2);
        } else {
            indexOfSlash = this.path.lastIndexOf("/");
            this.isFile = true;
        }
        this.name = indexOfSlash == -1 ? this.path : this.path.substring(indexOfSlash + 1);
        this.properties = new HashMap<String, String>(2);
    }

    public static boolean isFileRequest(String requestPath) {
        return requestPath != null && !requestPath.endsWith("/");
    }

    public static boolean isThemeRequest(String requestPath) {
        return PATTERN_THEME_REQUEST.matcher(requestPath).matches();
    }

    public static boolean isResourceBundleRequest(String requestPath) {
        return PATTERN_PROPERTIES_REQUEST.matcher(requestPath).matches();
    }

    public static String negotiateThemeRequest(String requestPath) {
        Matcher m = PATTERN_THEME_REQUEST.matcher(requestPath);
        if (m.matches()) {
            String prePath = m.group(1);
            String postPath = m.group(3);
            return prePath + BASE_THEME_NAME + postPath;
        }
        return requestPath;
    }

    public static String negotiateResourceBundleRequest(String requestPath) {
        Matcher m = PATTERN_PROPERTIES_REQUEST.matcher(requestPath);
        if (m.matches()) {
            String country;
            String prePath = m.group(1);
            String fileName = m.group(2);
            String lang = m.group(3) != null ? m.group(3) : "";
            String string = country = m.group(4) != null ? m.group(4) : "";
            if (!country.isEmpty()) {
                country = "";
            } else if (!lang.isEmpty()) {
                lang = "";
            }
            return prePath + fileName + lang + country + ".properties";
        }
        return requestPath;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public URL getUrl() {
        return this.url;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    protected void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    protected void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    protected void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public String toJSON() throws IOException {
        StringBuffer jsonString = new StringBuffer();
        jsonString.append("{");
        jsonString.append("\"name\":\"").append(XSSEncoder.encodeJSON(this.name)).append("\",");
        jsonString.append("\"path\":\"").append(XSSEncoder.encodeJSON(this.path)).append("\",");
        jsonString.append("\"url\":\"").append(XSSEncoder.encodeJSON(this.url.toString())).append("\",");
        jsonString.append("\"isFile\":").append(this.isFile).append(",");
        jsonString.append("\"lastModified\":\"").append(FormatterUtil.formatDate(this.lastModified)).append("\",");
        jsonString.append("\"contentLength\":\"").append(FormatterUtil.formatSize(this.contentLength)).append("\",");
        jsonString.append("\"contentType\":\"").append(this.contentType != null ? XSSEncoder.encodeJSON(this.contentType) : "").append("\",");
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            jsonString.append("\"").append(XSSEncoder.encodeJSON(entry.getKey())).append("\":\"").append(XSSEncoder.encodeJSON(entry.getValue())).append("\",");
        }
        jsonString.deleteCharAt(jsonString.length() - 1);
        jsonString.append("}");
        return jsonString.toString();
    }

    public void pipe(OutputStream os) throws IOException {
        InputStream is = null;
        try {
            is = this.getInputStream();
            ReadableByteChannel in = null;
            WritableByteChannel out = null;
            ByteBuffer buf = ByteBuffer.allocate(2048);
            in = Channels.newChannel(is);
            out = Channels.newChannel(os);
            int size = 0;
            int thisRead = in.read(buf);
            int totalWritten = 0;
            while (thisRead != -1) {
                buf.rewind();
                buf.limit(thisRead);
                while ((totalWritten += out.write(buf)) < size) {
                }
                buf.clear();
                size += thisRead;
                thisRead = in.read(buf);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public abstract InputStream getInputStream() throws IOException;
}

