/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource;

import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletRequest;

public interface ResourceConfig
extends Serializable {
    public static final String PARAM_PREFIX = "com.sap.ui5.resource.";
    public static final String PARAM_TEMPLATE_PATH = "com.sap.ui5.resource.TEMPLATE_PATH";
    public static final String PARAM_USE_CACHE = "com.sap.ui5.resource.USE_CACHE";
    public static final String PARAM_MAX_AGE = "com.sap.ui5.resource.MAX_AGE";
    public static final String PARAM_VERBOSE = "com.sap.ui5.resource.VERBOSE";
    public static final String PARAM_DEV_MODE = "com.sap.ui5.resource.DEV_MODE";
    public static final String PARAM_ACCEPTED_ORIGINS = "com.sap.ui5.resource.ACCEPTED_ORIGINS";
    public static final String PARAM_REMOTE_LOCATION = "com.sap.ui5.resource.REMOTE_LOCATION";
    public static final String PROP_PRODUCTIVE_PORTS = "com.sap.ui5.resource.PRODUCTIVE_PORTS";
    public static final String PROP_SERVER_TYPE = "com.sap.ui5.resource.SERVER_TYPE";
    public static final String DEFAULT_TEMPLATE_PATH = "/templates/listing.html";
    public static final boolean DEFAULT_USE_CACHE = true;
    public static final long DEFAULT_MAX_AGE = 604800000L;
    public static final long DEFAULT_INFINITE_MAX_AGE = 315360000000L;
    public static final String[] DEFAULT_ACCEPTED_ORIGINS = new String[0];
    public static final String[] DEFAULT_PRODUCTIVE_PORTS = new String[0];

    public String getTemplatePath();

    @Deprecated
    public boolean isUseCache();

    public boolean isUseCache(ServletRequest var1);

    public long getMaxAge();

    public boolean isVerbose();

    @Deprecated
    public boolean isDevMode();

    public boolean isDevMode(ServletRequest var1);

    public String[] getAcceptedOrigins();

    public String getRemoteLocation();

    public List<String> getProductivePorts();

    public ServerType getServerType();

    public Any getParameter(String var1);

    public static enum ServerType {
        Development,
        Productive;

    }

    public static class Any {
        private String value = null;

        public Any(String value) {
            this.value = value;
        }

        public boolean toBoolean() {
            return this.toBoolean(false);
        }

        public boolean toBoolean(boolean defaultValue) {
            if (this.value == null) {
                return defaultValue;
            }
            if ("1".equals(this.value) || "x".equalsIgnoreCase(this.value) || "on".equalsIgnoreCase(this.value)) {
                return true;
            }
            return Boolean.parseBoolean(this.value);
        }

        public int toInt() {
            return this.toInt(0);
        }

        public int toInt(int defaultValue) {
            try {
                return Integer.parseInt(this.value);
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }

        public long toLong() {
            return this.toLong(0L);
        }

        public long toLong(long defaultValue) {
            try {
                return Long.parseLong(this.value);
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }

        public float toFloat() {
            return this.toFloat(0.0f);
        }

        public float toFloat(float defaultValue) {
            try {
                return Float.parseFloat(this.value);
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(String defaultValue) {
            return this.value != null ? this.value : defaultValue;
        }

        public String[] toStringArray(String[] defaultValue) {
            return this.value != null ? this.value.split("(,|\\s)") : defaultValue;
        }
    }
}

