/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource;

import com.sap.ui5.resource.ResourceLocator;
import com.sap.ui5.resource.impl.ServletResourceLocator;
import javax.servlet.ServletContext;

public class ResourceLocatorFactory {
    private static final String OSGI_RESOURCE_LOCATOR = "com.sap.ui5.resource.impl.osgi.OSGiResourceLocator";

    private ResourceLocatorFactory() {
    }

    public static ResourceLocator createResourceLocator(ServletContext context) {
        ResourceLocator locator = null;
        try {
            Class<?> clazz = ResourceLocatorFactory.class.getClassLoader().loadClass(OSGI_RESOURCE_LOCATOR);
            locator = (ResourceLocator)clazz.newInstance();
        }
        catch (Exception ex) {
            locator = null;
        }
        if (locator == null) {
            locator = new ServletResourceLocator();
        }
        locator.init(context);
        return locator;
    }
}

