/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource;

import com.sap.ui5.resource.CacheControlFilter;
import com.sap.ui5.resource.Resource;
import com.sap.ui5.resource.ResourceConfig;
import com.sap.ui5.resource.ResourceLocator;
import com.sap.ui5.resource.ResourceLocatorFactory;
import com.sap.ui5.resource.Template;
import com.sap.ui5.resource.impl.ServletResource;
import com.sap.ui5.resource.impl.ServletResourceConfig;
import com.sap.ui5.resource.util.ResourceComparator;
import com.sap.ui5.resource.util.XSSEncoder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceServlet
extends HttpServlet {
    public static final String REQ_ATTR_RESOURCE_OVERLAY = ResourceServlet.class.getName() + ".OVERLAY";
    public static final String REQ_ATTR_CACHEBUSTER_REQUEST = ResourceServlet.class.getName() + ".CACHEBUSTER";
    public static final String REQ_ATTR_PATH = ResourceServlet.class.getName() + ".PATH";
    private static final String CTX_ATTR_CACHEBUSTER_TIMESTAMP = ResourceServlet.class.getName() + ".CACHEBUSTER_TIMESTAMP";
    private static final long serialVersionUID = -2721387829166070732L;
    private static final Logger LOG = Logger.getLogger(ResourceServlet.class.getName());
    private ResourceLocator locator = null;
    private Template template = null;
    private ResourceConfig config = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        ServletContext context = this.getServletContext();
        this.config = ServletResourceConfig.getInstance(context);
        this.locator = ResourceLocatorFactory.createResourceLocator(context);
        this.template = new Template(this.locator, this.config.getTemplatePath());
        String timestamp = (String)this.getServletContext().getAttribute(CTX_ATTR_CACHEBUSTER_TIMESTAMP);
        if (timestamp == null) {
            timestamp = Long.toString(System.currentTimeMillis());
            InputStream is = null;
            try {
                Properties prop = new Properties();
                is = context.getResourceAsStream("/META-INF/MANIFEST.MF");
                if (is == null) {
                    throw new IOException("MANIFEST.MF not found!");
                }
                prop.load(is);
                String value = prop.getProperty("x-sap-ui5-BuildTimestamp");
                if (value == null) {
                    value = prop.getProperty("x-sap-ui-BuildTimestamp");
                }
                if (value != null && !value.isEmpty()) {
                    timestamp = value;
                } else {
                    LOG.warning("Could not find property \"x-sap-ui5-BuildTimestamp\" in MANIFEST.MF! Using System.currentTimeMillis as cachebuster timestamp.");
                }
            }
            catch (IOException ex) {
                LOG.warning("MANIFEST.MF could not be found! Using System.currentTimeMillis as cachebuster timestamp.");
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.warning("Cannot close /META-INF/MANIFEST.MF: " + e.getMessage());
                    }
                }
            }
            this.getServletContext().setAttribute(CTX_ATTR_CACHEBUSTER_TIMESTAMP, (Object)timestamp);
        }
    }

    public void destroy() {
        this.template = null;
        this.locator = null;
        this.config = null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String urlPath = request.getServletPath();
        if (!"/resources".equals(urlPath) && !"/test-resources".equals(urlPath) && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Bad request: " + request.getServletPath() + " (do not queue non SAPUI5 resources/test-resources over ResourceServlet)");
        }
        request.setAttribute(REQ_ATTR_PATH, (Object)request.getPathInfo());
        if (this.handleCacheBusterRequest(request, response)) {
            return;
        }
        if (this.handleTestsuiteRequest(request, response)) {
            return;
        }
        if (this.handleBootstrapRequest(request, response)) {
            return;
        }
        String pathInfo = (String)request.getAttribute(REQ_ATTR_PATH);
        String requestPath = request.getServletPath() + (pathInfo != null ? pathInfo : "");
        if (Resource.isFileRequest(requestPath)) {
            this.serveResource(request, response, requestPath);
        } else if (this.config.isDevMode((ServletRequest)request)) {
            this.serveListing(request, response, requestPath);
        } else {
            response.sendError(403);
        }
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doOptions(request, response);
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Allow-Methods", "GET");
        response.addHeader("Access-Control-Allow-Headers", "x-requested-with");
        response.addHeader("Access-Control-Max-Age", "1728000");
    }

    private boolean handleTestsuiteRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = (String)request.getAttribute(REQ_ATTR_PATH);
        if ("/testsuite".equals(pathInfo)) {
            response.sendRedirect(request.getContextPath() + '/' + "resources" + "/testsuite/testframe.html");
            return true;
        }
        return false;
    }

    private boolean handleCacheBusterRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = (String)request.getAttribute(REQ_ATTR_PATH);
        if (pathInfo == null || pathInfo.isEmpty()) {
            return false;
        }
        if ("/sap-ui-cachebuster".equals(pathInfo)) {
            CacheControlFilter.addNoCacheHeaders(response);
            PrintWriter writer = new PrintWriter((OutputStream)response.getOutputStream());
            writer.write("~" + this.getServletContext().getAttribute(CTX_ATTR_CACHEBUSTER_TIMESTAMP) + "~");
            writer.flush();
            writer.close();
            return true;
        }
        if (pathInfo.startsWith("/sap-ui-cachebuster")) {
            if (pathInfo.endsWith(".js")) {
                CacheControlFilter.addNoCacheHeaders(response);
                String timeStamp = "~" + this.getServletContext().getAttribute(CTX_ATTR_CACHEBUSTER_TIMESTAMP) + "~";
                String scriptPath = pathInfo.substring("/sap-ui-cachebuster/".length());
                String encScriptPath = ((Object)XSSEncoder.encodeJavaScript(scriptPath)).toString();
                response.setCharacterEncoding("UTF-8");
                response.setContentType(this.getServletContext().getMimeType(pathInfo));
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream());
                writer.write("(function() {\r\n");
                writer.write("  var sTimeStamp = '" + timeStamp + "';\r\n");
                writer.write("  var sScriptPath = '" + encScriptPath + "';\r\n");
                writer.write("  var aScriptTags = document.getElementsByTagName('script');\r\n");
                writer.write("  for (var i = 0; i < aScriptTags.length; i++) {\r\n");
                writer.write("    if (aScriptTags[i].src) {\r\n");
                writer.write("      var iIdxCb = aScriptTags[i].src.indexOf('/sap-ui-cachebuster/');\r\n");
                writer.write("      if (iIdxCb >= 0 && aScriptTags[i].src.substring(iIdxCb + '/sap-ui-cachebuster/'.length) == sScriptPath) {\r\n");
                writer.write("        var sBasePath = aScriptTags[i].src.substring(0, iIdxCb);\r\n");
                writer.write("        sBasePath += '/' + sTimeStamp + '/';\r\n");
                if ("/resources".equals(request.getServletPath())) {
                    writer.write("        window[\"sap-ui-config\"] = window[\"sap-ui-config\"] || {};\r\n");
                    writer.write("        window[\"sap-ui-config\"].resourceRoots = window[\"sap-ui-config\"].resourceRoots || {};\r\n");
                    writer.write("        window[\"sap-ui-config\"].resourceRoots[''] = sBasePath;\r\n");
                }
                writer.write("        document.write('<script type=\"text/javascript\" src=\"' + sBasePath + sScriptPath + '\"></script>');\r\n");
                writer.write("        break;\r\n");
                writer.write("      }\r\n");
                writer.write("    }\r\n");
                writer.write("  }\r\n");
                writer.write("})();\r\n");
                writer.flush();
                writer.close();
                return true;
            }
            response.sendError(415);
            return true;
        }
        Matcher cbMatcher = Pattern.compile("/~[0-9-.]+~/(.*)?").matcher(pathInfo);
        if (cbMatcher.matches()) {
            pathInfo = "/" + cbMatcher.group(1);
            request.setAttribute(REQ_ATTR_PATH, (Object)pathInfo);
            request.setAttribute(REQ_ATTR_CACHEBUSTER_REQUEST, (Object)Boolean.TRUE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleBootstrapRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.config.isDevMode((ServletRequest)request) && System.getProperty("wtp.deploy") != null && "/sap-ui-core.js".equals(request.getPathInfo())) {
            Resource bootstrapFile = null;
            if (request.getAttribute(REQ_ATTR_RESOURCE_OVERLAY) != null) {
                bootstrapFile = (Resource)request.getAttribute(REQ_ATTR_RESOURCE_OVERLAY);
            } else {
                bootstrapFile = this.locator.findResource("/resources/sap-ui-core.js");
                if (bootstrapFile == null || "REMOTE".equals(bootstrapFile.getProperty("source"))) {
                    return false;
                }
            }
            Resource lessSupport = this.locator.findResource("/resources/sap/ui/core/plugin/LessSupport.js");
            if (bootstrapFile != null && lessSupport != null) {
                long identifier = Math.max(bootstrapFile.getLastModified(), lessSupport.getLastModified());
                File tempDir = new File(System.getProperty("java.io.tmpdir"));
                File tempBootstrap = new File(tempDir, "sap-ui-core-less-" + identifier + ".js");
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                if (!tempBootstrap.exists()) {
                    tempBootstrap.createNewFile();
                    tempBootstrap.deleteOnExit();
                    bootstrapFile.pipe(os);
                    lessSupport.pipe(os);
                    FileOutputStream fileOs = new FileOutputStream(tempBootstrap);
                    try {
                        os.writeTo(fileOs);
                    }
                    finally {
                        if (fileOs != null) {
                            ((OutputStream)fileOs).close();
                        }
                    }
                }
                ServletResource resource = new ServletResource(this.getServletContext(), request.getServletPath() + request.getPathInfo(), tempBootstrap.toURI().toURL(), "MODIFIED");
                request.setAttribute(REQ_ATTR_RESOURCE_OVERLAY, (Object)resource);
            }
        }
        return false;
    }

    private void serveResource(HttpServletRequest request, HttpServletResponse response, String requestPath) throws ServletException, IOException {
        long serviceMillis;
        long findMillis = serviceMillis = System.currentTimeMillis();
        Resource resource = null;
        resource = request.getAttribute(REQ_ATTR_RESOURCE_OVERLAY) != null ? (Resource)request.getAttribute(REQ_ATTR_RESOURCE_OVERLAY) : this.findResource(requestPath);
        findMillis = System.currentTimeMillis() - findMillis;
        long resMillis = 0L;
        long pipeMillis = 0L;
        int status = 200;
        String errorDescription = null;
        if (resource != null) {
            String origin;
            resMillis = Long.parseLong(resource.getProperty("millis"));
            boolean isCacheBusterRequest = Boolean.TRUE.equals(request.getAttribute(REQ_ATTR_CACHEBUSTER_REQUEST));
            boolean isUseCache = this.config.isUseCache((ServletRequest)request) || isCacheBusterRequest;
            CacheControlFilter.addHeaders(response, isUseCache, isCacheBusterRequest ? -1L : this.config.getMaxAge(), resource.getLastModified(), resource.getContentLength());
            if (requestPath.matches(".*-dbg((?:\\.view|\\.controller)?\\.js|\\.css)$")) {
                isUseCache = false;
            }
            if (this.config.isDevMode((ServletRequest)request)) {
                response.addHeader("x-sap-ResourceUrl", resource.getUrl().toString());
            }
            if ((origin = request.getHeader("Origin")) != null) {
                boolean accepted = false;
                String[] acceptedOrigins = this.config.getAcceptedOrigins();
                if (acceptedOrigins.length == 1 && "*".equals(acceptedOrigins[0])) {
                    origin = "*";
                    accepted = true;
                } else {
                    for (String acceptedOrigin : this.config.getAcceptedOrigins()) {
                        if (acceptedOrigin.startsWith("*")) {
                            if ((acceptedOrigin = acceptedOrigin.substring(1)).length() != 0 && !origin.endsWith(acceptedOrigin)) continue;
                            accepted = true;
                            break;
                        }
                        if (!acceptedOrigin.equals(origin)) continue;
                        accepted = true;
                        break;
                    }
                }
                if (accepted) {
                    String replyOrigin = origin;
                    if ("null".equals(origin)) {
                        replyOrigin = "*";
                    }
                    response.addHeader("Access-Control-Allow-Origin", replyOrigin);
                    LOG.info("Origin '" + origin + "' accepted by config (" + Arrays.toString(this.config.getAcceptedOrigins()) + ")");
                } else {
                    LOG.warning("Origin '" + origin + "' refused by config (" + Arrays.toString(this.config.getAcceptedOrigins()) + ")");
                }
            }
            if (CacheControlFilter.matchesETag(request, resource.getLastModified(), resource.getContentLength())) {
                status = 304;
                response.setStatus(status);
            } else {
                ServletOutputStream os;
                block24: {
                    response.setBufferSize(2048);
                    response.setContentType(resource.getContentType());
                    os = response.getOutputStream();
                    pipeMillis = System.currentTimeMillis();
                    try {
                        resource.pipe((OutputStream)os);
                    }
                    catch (IOException ex) {
                        if (this.config.isDevMode((ServletRequest)request)) {
                            status = 500;
                            errorDescription = ex.getMessage();
                            if (!response.isCommitted()) {
                                response.sendError(status, errorDescription);
                            }
                        } else {
                            status = 404;
                            errorDescription = "Resource could not be found!";
                            if (!response.isCommitted()) {
                                response.sendError(status, errorDescription);
                            }
                        }
                    }
                    catch (NullPointerException ex) {
                        status = 404;
                        errorDescription = "Resource could not be found!";
                        if (response.isCommitted()) break block24;
                        response.sendError(status, errorDescription);
                    }
                }
                pipeMillis = System.currentTimeMillis() - pipeMillis;
                os.close();
            }
        } else {
            status = 404;
            errorDescription = "Resource could not be found!";
            response.sendError(status, errorDescription);
        }
        if (status == 200 || status == 304) {
            if (this.config.isVerbose()) {
                String source = resource.getProperty("source");
                source = source != null ? " [" + source + "]" : "";
                LOG.info("[" + status + "] \"" + requestPath + "\"" + source + ": Service=" + (System.currentTimeMillis() - serviceMillis) + "ms, Find=" + findMillis + "ms, Resource=" + resMillis + "ms, Pipe=" + pipeMillis + "ms");
            }
        } else {
            LOG.warning("[" + status + "] \"" + requestPath + "\": Service=" + (System.currentTimeMillis() - serviceMillis) + "ms, Find=" + findMillis + "ms\n  Reason: " + errorDescription);
        }
    }

    private Resource findResource(String requestPath) {
        String newRequestPath;
        Resource resource = this.locator.findResource(requestPath);
        if (resource != null) {
            return resource;
        }
        if (Resource.isThemeRequest(requestPath) && !requestPath.equals(newRequestPath = Resource.negotiateThemeRequest(requestPath))) {
            return this.findResource(newRequestPath);
        }
        if (Resource.isResourceBundleRequest(requestPath) && !requestPath.equals(newRequestPath = Resource.negotiateResourceBundleRequest(requestPath))) {
            return this.findResource(newRequestPath);
        }
        return resource;
    }

    private void serveListing(HttpServletRequest request, HttpServletResponse response, String requestPath) throws ServletException, IOException {
        long serviceMillis = System.currentTimeMillis();
        response.setCharacterEncoding("UTF-8");
        response.setBufferSize(2048);
        int status = 200;
        String errorDescription = null;
        if (request.getParameter("format") == null) {
            String templateContent = this.template.getContent();
            if (templateContent != null) {
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/html");
                PrintWriter writer = response.getWriter();
                writer.write(templateContent.replace("${requestPath}", XSSEncoder.encodeHTML(requestPath)).replace("${resources}", this.createJSONData(requestPath, true)));
                writer.close();
            } else {
                status = 500;
                errorDescription = "No template was found!";
                response.sendError(status, errorDescription);
            }
        } else if ("json".equalsIgnoreCase(request.getParameter("format"))) {
            response.setContentType("text/json");
            PrintWriter writer = response.getWriter();
            writer.write(this.createJSONData(requestPath, false));
            writer.close();
        } else {
            status = 501;
            errorDescription = "The requested format is not supported!";
            response.sendError(status, errorDescription);
        }
        if (status == 200 || status == 304) {
            if (this.config.isVerbose()) {
                LOG.info("[" + status + "] \"" + requestPath + "\": Service=" + (System.currentTimeMillis() - serviceMillis) + "ms");
            }
        } else {
            LOG.warning("[" + status + "] \"" + requestPath + "\": Service=" + (System.currentTimeMillis() - serviceMillis) + "ms\n  Reason: " + errorDescription);
        }
    }

    private String createJSONData(String requestPath, boolean encodeForString) throws IOException {
        List<Resource> resources = this.locator.listResources(requestPath);
        Collections.sort(resources, ResourceComparator.getInstance());
        StringBuffer data = new StringBuffer();
        data.append("[");
        boolean first = true;
        for (Resource resource : resources) {
            if (resource == null) continue;
            if (first) {
                first = false;
            } else {
                data.append(",");
            }
            data.append(resource.toJSON());
        }
        data.append("]");
        String returnData = data.toString();
        if (encodeForString) {
            returnData = returnData.replace("\\", "\\\\");
            returnData = returnData.replace("\"", "\\\"");
        }
        return returnData;
    }
}

