/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ResourceUtil {
    private static final ResourceUtil INSTANCE = new ResourceUtil();
    public static final String CLASSPATH_PATH_PREFIX = "META-INF";
    public static final String TYPE_RESOURCES = "resources";
    public static final String TYPE_TEST_RESOURCES = "test-resources";
    private static final String DEFAULT_RESOURCES_LOCATION = "resources";
    private static final String DEFAULT_TEST_RESOURCES_LOCATION = "test-resources";
    private Map<String, String> resourceMapping;

    private ResourceUtil() {
    }

    public static ResourceUtil getInstance() {
        return INSTANCE;
    }

    public Map<String, String> getResourceMapping() {
        if (this.resourceMapping != null) {
            return this.resourceMapping;
        }
        String resources = null;
        String testResources = null;
        InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/sap-ui5-config.xml");
        if (inStream != null) {
            Document document;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inStream);
            }
            catch (Exception e) {
                document = null;
            }
            if (document != null) {
                Node node;
                NodeList elems = document.getElementsByTagName("resources");
                if (elems != null) {
                    if (elems.getLength() != 1) {
                        throw new IllegalStateException("mutiple 'resources' elements found");
                    }
                    node = elems.item(0);
                    resources = node.getTextContent();
                }
                if ((elems = document.getElementsByTagName("test-resources")) != null) {
                    if (elems.getLength() != 1) {
                        throw new IllegalStateException("mutiple 'test-resources' elements found");
                    }
                    node = elems.item(0);
                    testResources = node.getTextContent();
                }
            }
        }
        this.resourceMapping = new HashMap<String, String>();
        this.resourceMapping.put("resources", resources == null ? "resources" : resources);
        this.resourceMapping.put("test-resources", testResources == null ? "test-resources" : testResources);
        return this.resourceMapping;
    }
}

