/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource;

import com.sap.ui5.resource.Resource;
import com.sap.ui5.resource.ResourceLocator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Template {
    private ResourceLocator locator = null;
    private String path = null;
    private String content = null;
    private long lastModified = -1L;

    public Template(ResourceLocator locator, String path) {
        this.locator = locator;
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String getContent() throws IOException {
        Resource resource = this.locator.findResource(this.path);
        if (resource != null && resource.isFile()) {
            if (this.content == null || this.lastModified < resource.getLastModified()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getUrl().openStream()));
                StringBuffer contentBuffer = new StringBuffer();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    contentBuffer.append(line);
                    contentBuffer.append(System.getProperty("line.separator"));
                }
                reader.close();
                this.content = contentBuffer.toString();
                this.lastModified = resource.getLastModified();
            }
        } else {
            this.content = null;
            this.lastModified = -1L;
        }
        return this.content;
    }
}

