/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource.impl;

import com.sap.ui5.resource.Resource;
import com.sap.ui5.resource.impl.ServletResourceConfig;
import com.sap.ui5.resource.util.LocalFileURLConnection;
import com.sap.ui5.resource.util.LocalJarURLConnection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletContext;

public class ServletResource
extends Resource {
    private ServletContext context = null;
    private boolean isJarResource = false;
    private boolean isFileResource = false;
    private boolean isRemoteResource = false;
    private URLConnection connection = null;

    public ServletResource(ServletContext context, String path, URL url) throws MalformedURLException {
        super(path, url);
        this.context = context;
        long millis = System.currentTimeMillis();
        boolean isDevMode = ServletResourceConfig.getInstance(this.context).isDevMode();
        String protocol = url.getProtocol();
        this.isJarResource = "jar".equalsIgnoreCase(protocol);
        this.isFileResource = "file".equalsIgnoreCase(protocol);
        this.isRemoteResource = "http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol);
        try {
            this.connection = this.isJarResource ? new LocalJarURLConnection(url) : (this.isFileResource ? new LocalFileURLConnection(url) : this.getUrl().openConnection());
            if (this.isJarResource || this.isFileResource || !path.endsWith("/")) {
                this.connection.setAllowUserInteraction(false);
                this.connection.setUseCaches(false);
                this.connection.connect();
                if (this.isRemoteResource && this.connection instanceof HttpURLConnection) {
                    HttpURLConnection httpConnection = (HttpURLConnection)this.connection;
                    this.setProperty("statusCode", String.valueOf(httpConnection.getResponseCode()));
                }
                this.setLastModified(this.connection.getLastModified());
                this.setContentLength(this.connection.getContentLength());
                this.setContentEncoding(this.connection.getContentEncoding());
                this.setContentType(this.context.getMimeType(this.getName()));
                if (ServletResource.isResourceBundleRequest(path)) {
                    this.setContentType("text/plain;charset=ISO-8859-1");
                }
                if (isDevMode) {
                    this.setProperty("localFileUrl", this.getUrl().toString());
                    if (this.connection instanceof LocalFileURLConnection) {
                        File localFile = ((LocalFileURLConnection)this.connection).getLocalFile();
                        this.setProperty("localFileName", localFile.getName());
                        this.setProperty("localDir", localFile.getParentFile().toURI().toURL().toString());
                    } else {
                        this.setProperty("localFileName", this.getName());
                        this.setProperty("localDir", this.getUrl().toString());
                    }
                }
            } else if (isDevMode) {
                this.setProperty("localFileUrl", this.getUrl().toString());
                this.setProperty("localFileName", this.getName());
                this.setProperty("localDir", this.getUrl().toString());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.setProperty("millis", Long.toString(System.currentTimeMillis() - millis));
    }

    public ServletResource(ServletContext context, String path, URL url, String source) throws MalformedURLException {
        this(context, path, url);
        this.setProperty("source", source);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }
}

