/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource.impl;

import com.sap.ui5.resource.ResourceConfig;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

public class ServletResourceConfig
implements ResourceConfig {
    private static final long serialVersionUID = 378751705597198463L;
    private static final Logger LOG = Logger.getLogger(ServletResourceConfig.class.getName());
    private ServletContext context = null;
    private String templatePath = null;
    private boolean useCache = false;
    private long maxAge = 0L;
    private boolean verbose = true;
    private boolean devMode = false;
    private String[] acceptedOrigins;
    private String remoteLocation;
    private List<String> productivePorts;
    private ResourceConfig.ServerType serverType = ResourceConfig.ServerType.Development;

    private ServletResourceConfig(ServletContext context) {
        this.context = context;
        this.templatePath = this.getParameter("com.sap.ui5.resource.TEMPLATE_PATH").toString("/templates/listing.html");
        this.devMode = this.getParameter("com.sap.ui5.resource.DEV_MODE").toBoolean();
        this.maxAge = this.getParameter("com.sap.ui5.resource.MAX_AGE").toLong(604800000L);
        this.acceptedOrigins = this.getParameter("com.sap.ui5.resource.ACCEPTED_ORIGINS").toStringArray(DEFAULT_ACCEPTED_ORIGINS);
        this.remoteLocation = this.getParameter("com.sap.ui5.resource.REMOTE_LOCATION").toString();
        Object[] prodPorts = ServletResourceConfig.getSystemProperty("com.sap.ui5.resource.PRODUCTIVE_PORTS").toStringArray(DEFAULT_PRODUCTIVE_PORTS);
        this.productivePorts = Arrays.asList(prodPorts);
        if (ServletResourceConfig.getSystemProperty("com.sap.ui5.resource.SERVER_TYPE").toString() != null) {
            this.serverType = ResourceConfig.ServerType.valueOf(ServletResourceConfig.getSystemProperty("com.sap.ui5.resource.SERVER_TYPE").toString());
            this.devMode = ResourceConfig.ServerType.Productive != this.serverType;
            boolean bl = this.useCache = ResourceConfig.ServerType.Productive == this.serverType;
        }
        if (ResourceConfig.ServerType.Productive != this.serverType && (this.devMode && this.getParameter("com.sap.ui5.resource.USE_CACHE").toString() != null || !this.devMode)) {
            this.useCache = this.getParameter("com.sap.ui5.resource.USE_CACHE").toBoolean(true);
        }
        if (this.devMode && this.getParameter("com.sap.ui5.resource.VERBOSE").toString() != null || !this.devMode) {
            this.verbose = this.getParameter("com.sap.ui5.resource.VERBOSE").toBoolean();
        }
        if (this.verbose) {
            StringBuffer log = new StringBuffer();
            log.append("ResourceServlet configuration for web application: " + context.getServletContextName() + "\n");
            if (this.devMode) {
                log.append("  - com.sap.ui5.resource.TEMPLATE_PATH: " + this.templatePath + "\n");
            }
            log.append("  - com.sap.ui5.resource.SERVER_TYPE: " + (Object)((Object)this.serverType) + "\n");
            log.append("  - com.sap.ui5.resource.PRODUCTIVE_PORTS: " + Arrays.toString(prodPorts) + "\n");
            log.append("  - com.sap.ui5.resource.USE_CACHE: " + this.useCache + "\n");
            log.append("  - com.sap.ui5.resource.MAX_AGE: " + this.maxAge + "\n");
            log.append("  - com.sap.ui5.resource.ACCEPTED_ORIGINS: " + Arrays.toString(this.acceptedOrigins) + "\n");
            log.append("  - com.sap.ui5.resource.REMOTE_LOCATION: " + (this.remoteLocation != null ? this.remoteLocation : "n/a") + "\n");
            log.append("    - http.proxyHost: " + System.getProperty("http.proxyHost", "n/a") + "\n");
            log.append("    - http.proxyPort: " + System.getProperty("http.proxyPort", "n/a") + "\n");
            log.append("    - http.nonProxyHosts: " + System.getProperty("http.nonProxyHosts", "n/a") + "\n");
            log.append("    - https.proxyHost: " + System.getProperty("https.proxyHost", "n/a") + "\n");
            log.append("    - https.proxyPort: " + System.getProperty("https.proxyPort", "n/a") + "\n");
            log.append("    - https.nonProxyHosts: " + System.getProperty("https.nonProxyHosts", "n/a") + "\n");
            log.append("  - com.sap.ui5.resource.VERBOSE: " + this.verbose);
            LOG.info(log.toString());
        }
    }

    public static ServletResourceConfig getInstance(ServletContext context) {
        ServletResourceConfig instance = (ServletResourceConfig)context.getAttribute(ResourceConfig.class.getName());
        if (instance == null) {
            instance = new ServletResourceConfig(context);
            context.setAttribute(ResourceConfig.class.getName(), (Object)instance);
        }
        return instance;
    }

    private static ResourceConfig.Any getSystemProperty(String name) {
        String value = System.getProperty(name);
        return new ResourceConfig.Any(value);
    }

    @Override
    public ResourceConfig.Any getParameter(String name) {
        String value = this.context.getInitParameter(name);
        return new ResourceConfig.Any(value);
    }

    @Override
    public String getTemplatePath() {
        return this.templatePath;
    }

    @Override
    public boolean isUseCache() {
        return this.useCache;
    }

    @Override
    public boolean isUseCache(ServletRequest request) {
        boolean isProductive = this.productivePorts.contains("" + request.getLocalPort());
        return this.useCache || isProductive;
    }

    @Override
    public long getMaxAge() {
        return this.maxAge;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public boolean isDevMode() {
        return this.devMode;
    }

    @Override
    public boolean isDevMode(ServletRequest request) {
        if (this.devMode) {
            boolean isProductive = this.productivePorts.contains("" + request.getLocalPort());
            return !isProductive;
        }
        return false;
    }

    @Override
    public String[] getAcceptedOrigins() {
        return this.acceptedOrigins;
    }

    @Override
    public String getRemoteLocation() {
        return this.remoteLocation;
    }

    @Override
    public List<String> getProductivePorts() {
        return this.productivePorts;
    }

    @Override
    public ResourceConfig.ServerType getServerType() {
        return this.serverType;
    }
}

