/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource.impl;

import com.sap.ui5.resource.Resource;
import com.sap.ui5.resource.ResourceLocator;
import com.sap.ui5.resource.impl.ServletResource;
import com.sap.ui5.resource.impl.ServletResourceConfig;
import com.sap.ui5.resource.util.ClasspathUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public class ServletResourceLocator
implements ResourceLocator {
    private static final Logger LOG = Logger.getLogger(ServletResourceLocator.class.getName());
    private ServletContext context = null;
    private String remoteLocation = null;

    @Override
    public void init(ServletContext context) {
        this.context = context;
        ServletResourceConfig config = ServletResourceConfig.getInstance(this.context);
        this.remoteLocation = config.getRemoteLocation();
    }

    @Override
    public Resource findResource(String requestPath) {
        URL resourceUrl;
        assert (this.context != null);
        try {
            String realPath;
            boolean isServletContextResource = this.context.getResource(requestPath) != null;
            URL resourceUrl2 = null;
            if (isServletContextResource && (resourceUrl2 = new File(realPath = this.context.getRealPath(requestPath)).toURI().toURL()) != null) {
                return new ServletResource(this.context, requestPath, resourceUrl2, "CONTEXT");
            }
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.WARNING, "Failed to resolve resource from context path due to invalid URL!\n", ex);
        }
        try {
            resourceUrl = ClasspathUtil.getResource(requestPath);
            if (resourceUrl != null) {
                return new ServletResource(this.context, requestPath, resourceUrl, "CLASSPATH");
            }
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.WARNING, "Failed to resolve resource from classpath due to invalid URL!\n", ex);
        }
        if (this.remoteLocation != null) {
            try {
                resourceUrl = new URL(this.remoteLocation + requestPath);
                ServletResource resource = new ServletResource(this.context, requestPath, resourceUrl, "REMOTE");
                if ("200".equals(resource.getProperty("statusCode"))) {
                    return resource;
                }
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.WARNING, "Failed to resolve resource from remote location due to invalid URL!\n", ex);
            }
        }
        return null;
    }

    @Override
    public List<Resource> listResources(String requestPath) {
        assert (this.context != null);
        if (!Resource.isFileRequest(requestPath)) {
            Set<String> cpResourcePaths;
            ArrayList<Resource> resources = new ArrayList<Resource>();
            Set resourcePaths = this.context.getResourcePaths(requestPath);
            if (resourcePaths != null) {
                for (String resourcePath : resourcePaths) {
                    resources.add(this.findResource(resourcePath));
                }
            }
            if ((cpResourcePaths = ClasspathUtil.getResourcePaths(requestPath)) != null) {
                for (String resourcePath : cpResourcePaths) {
                    Set<URL> cpResourceURLs = ClasspathUtil.getResources(resourcePath);
                    for (URL resourceUrl : cpResourceURLs) {
                        try {
                            resources.add(new ServletResource(this.context, resourcePath, resourceUrl, "CLASSPATH"));
                        }
                        catch (MalformedURLException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            return resources;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> listResourcePaths(String requestPath) {
        assert (this.context != null);
        if (!Resource.isFileRequest(requestPath)) {
            Set<String> cpResourcePaths;
            ArrayList<String> paths = new ArrayList<String>();
            Set resourcePaths = this.context.getResourcePaths(requestPath);
            if (resourcePaths != null) {
                paths.addAll(resourcePaths);
            }
            if ((cpResourcePaths = ClasspathUtil.getResourcePaths(requestPath)) != null) {
                paths.addAll(cpResourcePaths);
            }
            return paths;
        }
        return Collections.EMPTY_LIST;
    }
}

