/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ClasspathUtil {
    private static final Logger LOG = Logger.getLogger(ClasspathUtil.class.getName());
    private static Map<String, List<String>> JAR_CACHE = new HashMap<String, List<String>>();

    private ClasspathUtil() {
    }

    public static URL getResource(String requestPath) {
        ClassLoader cl = ClasspathUtil.getClasspathClassLoader();
        return ClasspathUtil.isValidRequestPath(requestPath) ? cl.getResource("META-INF" + requestPath) : null;
    }

    public static Set<URL> getResources(String requestPath) {
        if (ClasspathUtil.isValidRequestPath(requestPath)) {
            ClassLoader cl = ClasspathUtil.getClasspathClassLoader();
            try {
                HashSet<URL> resources = new HashSet<URL>();
                Enumeration<URL> urls = cl.getResources("META-INF" + requestPath);
                while (urls.hasMoreElements()) {
                    resources.add(urls.nextElement());
                }
                return resources;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return Collections.EMPTY_SET;
    }

    public static String getRealPath(String requestPath) {
        URL resource = ClasspathUtil.getResource(requestPath);
        return resource.toString();
    }

    public static Set<String> getResourcePaths(String requestPath) {
        ClassLoader cl = ClasspathUtil.getClasspathClassLoader();
        try {
            TreeSet<String> resourcePaths = new TreeSet<String>();
            if (ClasspathUtil.isValidRequestPath(requestPath)) {
                Enumeration<URL> urls = cl.getResources("META-INF" + requestPath);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if ("jar".equalsIgnoreCase(url.getProtocol())) {
                        ClasspathUtil.appendJarResourcePaths(requestPath, url, resourcePaths);
                        continue;
                    }
                    if ("file".equalsIgnoreCase(url.getProtocol())) {
                        ClasspathUtil.appendFileResourcePaths(requestPath, url, resourcePaths);
                        continue;
                    }
                    if (!"bundleresource".equalsIgnoreCase(url.getProtocol())) continue;
                    ClasspathUtil.appendBundleResourcePaths(requestPath, resourcePaths);
                }
            }
            return resourcePaths;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return Collections.EMPTY_SET;
        }
    }

    private static void appendBundleResourcePaths(String requestPath, Set<String> resourcePaths) throws IOException {
        try {
            File[] classpath;
            ClassLoader cl = ClasspathUtil.getClasspathClassLoader();
            Field f = cl.getClass().getDeclaredField("bundle");
            boolean wasAccessible = f.isAccessible();
            f.setAccessible(true);
            Object bundle = f.get(cl);
            f.setAccessible(wasAccessible);
            f = bundle.getClass().getSuperclass().getDeclaredField("bundledata");
            wasAccessible = f.isAccessible();
            f.setAccessible(true);
            Object bundledata = f.get(bundle);
            f.setAccessible(wasAccessible);
            f = bundledata.getClass().getDeclaredField("bundleFiles");
            wasAccessible = f.isAccessible();
            f.setAccessible(true);
            Object bundlefiles = f.get(bundledata);
            f.setAccessible(wasAccessible);
            for (File file : classpath = ((Collection)bundlefiles).toArray(new File[0])) {
                URL jarUrl = new URL("jar:" + file.toURI().toURL() + "!/");
                ClasspathUtil.appendJarResourcePaths(requestPath, jarUrl, resourcePaths);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Issue occured in determine resource of WAR in OSGi Servlet Container:\r\n" + t.getMessage(), t);
        }
    }

    private static void appendFileResourcePaths(String requestPath, URL fileUrl, Set<String> resourcePaths) throws IOException {
        try {
            File[] childs;
            File file = new File(fileUrl.toURI());
            for (File child : childs = file.listFiles()) {
                resourcePaths.add(requestPath + child.getName() + (child.isDirectory() ? "/" : ""));
            }
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    private static void appendJarResourcePaths(String requestPath, URL jarUrl, Set<String> resourcePaths) throws IOException {
        URL fileUrl = new URL(jarUrl.getFile().substring(0, jarUrl.getFile().indexOf("!/")));
        URLConnection conn = fileUrl.openConnection();
        conn.setUseCaches(false);
        long lastModified = conn.getLastModified();
        String key = fileUrl + "|" + lastModified;
        Pattern pathPattern = Pattern.compile("^" + Pattern.quote("META-INF" + requestPath) + "[^/]+/?$");
        if (JAR_CACHE.containsKey(key)) {
            List<String> cache = JAR_CACHE.get(key);
            for (String name : cache) {
                if (!pathPattern.matcher(name).matches()) continue;
                resourcePaths.add(name.substring("META-INF".length()));
            }
        } else {
            ArrayList<String> cache = new ArrayList<String>();
            JarInputStream stream = new JarInputStream(conn.getInputStream());
            JarEntry entry = stream.getNextJarEntry();
            while (entry != null) {
                String name = entry.getName();
                cache.add(name);
                if (pathPattern.matcher(name).matches()) {
                    resourcePaths.add(name.substring("META-INF".length()));
                }
                entry = stream.getNextJarEntry();
            }
            stream.close();
            JAR_CACHE.put(key, cache);
        }
    }

    private static ClassLoader getClasspathClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClasspathUtil.class.getClassLoader();
        }
        return cl;
    }

    private static boolean isValidRequestPath(String requestPath) {
        return requestPath != null && requestPath.startsWith("/") && !requestPath.contains("/../") && !requestPath.endsWith("/..");
    }
}

