/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public class LocalFileURLConnection
extends URLConnection {
    protected File localFile = null;

    public LocalFileURLConnection(URL url) {
        super(url);
    }

    public File getLocalFile() {
        return this.localFile;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public int getContentLength() {
        if (this.localFile != null) {
            return (int)this.localFile.length();
        }
        return -1;
    }

    @Override
    public long getLastModified() {
        if (this.localFile != null) {
            return this.localFile.lastModified();
        }
        return 0L;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.localFile);
    }

    @Override
    public void connect() throws IOException {
        try {
            this.localFile = new File(this.url.toURI());
            this.connected = true;
        }
        catch (URISyntaxException ex) {
            throw new IOException("URL is not supported: \"" + this.url + "\" by this URLConnection!", ex);
        }
    }
}

