/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource.util;

import com.sap.ui5.resource.util.LocalFileURLConnection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class LocalJarURLConnection
extends LocalFileURLConnection {
    private JarFile jarFile = null;
    private JarEntry jarEntry = null;

    public LocalJarURLConnection(URL url) {
        super(url);
    }

    @Override
    public int getContentLength() {
        if (this.jarEntry != null) {
            return (int)this.jarEntry.getSize();
        }
        return -1;
    }

    @Override
    public long getLastModified() {
        if (this.jarEntry != null) {
            return this.jarEntry.getTime();
        }
        return 0L;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.jarFile != null && this.jarEntry != null) {
            return this.jarFile.getInputStream(this.jarEntry);
        }
        throw new IOException("Invalid URL!");
    }

    @Override
    public void connect() throws IOException {
        String spec = this.url.getFile();
        spec = spec.replace(" ", "%20");
        int separator = spec.indexOf("!/");
        URL jarFileURL = new URL(spec.substring(0, separator++));
        String entryName = URLDecoder.decode(spec.substring(++separator), System.getProperty("file.encoding"));
        try {
            URI uri = jarFileURL.toURI();
            this.localFile = !uri.isOpaque() ? new File(uri) : new File(jarFileURL.getFile());
            this.jarFile = new JarFile(this.localFile);
            this.jarEntry = this.jarFile.getJarEntry(entryName);
        }
        catch (URISyntaxException ex) {
            throw new IOException("URL is not supported: \"" + this.url + "\" by this URLConnection!", ex);
        }
        this.connected = true;
    }
}

