/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ui5.resource.util;

import com.sap.ui5.resource.Resource;
import java.util.Comparator;

public class ResourceComparator
implements Comparator<Resource> {
    private static final ResourceComparator INSTANCE = new ResourceComparator();

    private ResourceComparator() {
    }

    public static ResourceComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(Resource res1, Resource res2) {
        if (res1 == null || res1.getPath() == null || res2 == null || res2.getPath() == null) {
            return 0;
        }
        boolean res1IsFolder = res1.getPath().endsWith("/");
        boolean res2IsFolder = res2.getPath().endsWith("/");
        if (res1IsFolder && res2IsFolder || !res1IsFolder && !res2IsFolder) {
            return res1.getPath().compareToIgnoreCase(res2.getPath());
        }
        if (res1IsFolder) {
            return -1;
        }
        if (res2IsFolder) {
            return 1;
        }
        return 0;
    }
}

