/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Affiliation;
import com.sap.security.saml2.cfg.interfaces.write.SAML2AffiliationSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SAML2AffiliationImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2Affiliation,
SAML2AffiliationSetter {
    private static final String TOSTRING_PATTERN = "Name: {0}\nOwner: {1}\nMembers: {2}\nUser attribute name: {3}\nUser attribute namespace: {4}\nCfg path: {5}";
    private static final String KEY_NAME = "name";
    private static final String KEY_OWNER = "owner";
    private static final String KEY_MEMBERS = "members";
    private static final String KEY_USER_ATTRIBUTE_NAME = "user_attr_name";
    private static final String KEY_USER_ATTRIBUTE_NAMESPACE = "user_attr_namespace";
    private String name;
    private String owner;
    private Set<String> members;
    private String userAttributeName;
    private String userAttributeNamespace;

    public SAML2AffiliationImpl() {
    }

    public SAML2AffiliationImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        super(parent, subPath, propertySheet);
    }

    @Override
    public Set<String> getMembers() {
        if (this.members == null) {
            this.members = new HashSet<String>(0);
        }
        return Collections.unmodifiableSet(this.members);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getUserAttributeName() {
        return this.userAttributeName;
    }

    @Override
    public String getUserAttributeNamespace() {
        return this.userAttributeNamespace;
    }

    @Override
    public void setMembers(Set<String> members) {
        this.members = members;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public void setUserAttributeName(String attrName) {
        this.userAttributeName = attrName;
    }

    @Override
    public void setUserAttributeNamespace(String attrNamespace) {
        this.userAttributeNamespace = attrNamespace;
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        this.name = this.readProperty(KEY_NAME);
        this.owner = this.readProperty(KEY_OWNER);
        String[] membersArray = this.readArrayProperty(KEY_MEMBERS);
        if (membersArray != null) {
            this.members = new HashSet<String>(membersArray.length);
            String[] stringArray = membersArray;
            int n = membersArray.length;
            int n2 = 0;
            while (n2 < n) {
                String member = stringArray[n2];
                if (member != null) {
                    this.members.add(member);
                }
                ++n2;
            }
        }
        this.userAttributeName = this.readProperty(KEY_USER_ATTRIBUTE_NAME);
        this.userAttributeNamespace = this.readProperty(KEY_USER_ATTRIBUTE_NAMESPACE);
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        this.setProperty(KEY_NAME, this.name);
        this.setProperty(KEY_OWNER, this.owner);
        if (this.members != null && !this.members.isEmpty()) {
            String[] membersArray = this.members.toArray(new String[this.members.size()]);
            this.setProperty(KEY_MEMBERS, membersArray);
        }
        this.setProperty(KEY_USER_ATTRIBUTE_NAME, this.userAttributeName);
        this.setProperty(KEY_USER_ATTRIBUTE_NAMESPACE, this.userAttributeNamespace);
        super.writeConfiguration();
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.name, this.owner, this.members, this.userAttributeName, this.userAttributeNamespace, super.toString());
    }
}

