/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.storage.CfgPropertySetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Location;

public abstract class SAML2AnonymousSubCfgObjectBase
extends SAML2CfgObject {
    private static final Location LOCATION = Location.getLocation(SAML2AnonymousSubCfgObjectBase.class);
    private static final byte STATE_READING = 2;
    private static final byte STATE_WRITING = 4;
    private static final byte STATE_WRITTEN = 8;
    private byte state;
    private CfgPropertySetter propertySetter;
    boolean isWritingNewAnonymousSubNode;

    public SAML2AnonymousSubCfgObjectBase() {
        this.state = (byte)4;
    }

    public SAML2AnonymousSubCfgObjectBase(String propertySheetName) {
        this.state = (byte)4;
        super.setCfgPropertySheet(propertySheetName);
        this.isWritingNewAnonymousSubNode = true;
    }

    public SAML2AnonymousSubCfgObjectBase(SAML2CfgObject parent, String subPath, String propertySheet) {
        this(parent, subPath, propertySheet, false);
    }

    public SAML2AnonymousSubCfgObjectBase(SAML2CfgObject parent, String subPath, String propertySheet, boolean isWriteMode) {
        super(parent, String.valueOf(parent.getCfgPath()) + "/" + subPath, propertySheet, true);
        this.state = isWriteMode ? (byte)4 : (byte)2;
        this.readConfiguration(isWriteMode);
    }

    public SAML2AnonymousSubCfgObjectBase(String cfgPath, String propertySheet) {
        this(cfgPath, propertySheet, false);
    }

    public SAML2AnonymousSubCfgObjectBase(String cfgPath, String propertySheet, boolean isWriteMode) {
        super(cfgPath, propertySheet, true);
        if (isWriteMode) {
            this.state = (byte)4;
            this.isWritingNewAnonymousSubNode = true;
        } else {
            this.state = (byte)2;
        }
        this.readConfiguration(isWriteMode);
    }

    protected String readProperty(String key) {
        return this.readProperty(key, null);
    }

    protected String readProperty(String key, String defaultValue) {
        return this.getPropertyValue(key, defaultValue).getValue();
    }

    protected boolean readBooleanProperty(String key, boolean defaultValue) {
        String value = this.readProperty(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    protected Integer readIntegerProperty(String key) {
        Integer result;
        block3: {
            result = null;
            String dbValue = this.readProperty(key);
            if (!CfgUtils.isEmpty(dbValue)) {
                try {
                    result = Integer.parseInt(dbValue);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOCATION.beWarning()) break block3;
                    LOCATION.warningT("Could not parse the value:{0} of the configured property: {1} as Integer", new Object[]{dbValue, key});
                }
            }
        }
        return result;
    }

    protected String[] readArrayProperty(String key) {
        return this.getPropertyValue(key, null).getValues();
    }

    protected void setProperty(String key, String value) {
        this.propertySetter.setProperty(key, value);
    }

    protected void setProperty(String key, String[] values) {
        this.propertySetter.setProperty(key, values);
    }

    protected void setProperty(String key, Boolean value) {
        if (value != null) {
            this.propertySetter.setProperty(key, value.toString());
        } else {
            this.propertySetter.setProperty(key, (String)null);
        }
    }

    protected void setProperty(String key, Integer value) {
        if (value != null) {
            this.propertySetter.setProperty(key, value.toString());
        } else {
            this.propertySetter.setProperty(key, (String)null);
        }
    }

    protected abstract void readConfiguration();

    protected abstract void readConfiguration(boolean var1);

    protected abstract void createAndWriteConfiguration(SAML2CfgObject var1, String var2) throws CfgStorageException;

    protected void createConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        if (this.state != 4) {
            throw new IllegalStateException("This anonymous sub configuration is intended only for reading");
        }
        this.setCfgPath(String.valueOf(parent.getCfgPath()) + "/" + subPath);
        if (this.isWritingNewAnonymousSubNode) {
            this.createAndSetAnonymousSubCfg();
        } else {
            this.createAndSetAnonymousPropertySheet();
        }
        this.propertySetter = this.getPropertySetter();
    }

    protected void writeConfiguration() throws CfgStorageException {
        if (this.state == 2) {
            throw new IllegalStateException("This anonymous sub configuration is intended only for reading");
        }
        if (this.state == 8) {
            throw new IllegalStateException("This anonymous sub configuration is already written");
        }
        super.write(this.propertySetter);
        this.state = (byte)8;
    }
}

