/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2SubCfgObjectBase;
import com.sap.security.saml2.cfg.interfaces.read.SAML2BackChannelSecurityPolicy;
import com.sap.security.saml2.cfg.interfaces.write.SAML2BackChannelSecurityPolicySetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import java.text.MessageFormat;

public class SAML2BackChannelSecurityPolicyImpl
extends SAML2SubCfgObjectBase
implements SAML2BackChannelSecurityPolicy,
SAML2BackChannelSecurityPolicySetter {
    private static final String TOSTRING_PATTERN = "HTTPS required: {0}\nAuthentication enabled: {1}\nClient certtificate authentication accepted: {2}\nHTTP Basic authentication accepted: {3}\nCfg path: {4}";
    private static final String RELATIVE_PATH = "back_channel_security";
    private static final String KEY_IS_HTTPS_REQUIRED = "https_required";
    private static final String KEY_IS_AUTHENTICATION_ENABLED = "authn_enabled";
    private static final String KEY_IS_CLIENT_CERT_AUTHN_ACCEPTED = "client_cert_accepted";
    private static final String KEY_IS_HTTP_BASIC_AUTHN_ACCEPTED = "http_basic_accepted";
    private boolean isHTTPSRequired;
    private boolean isAuthenticationEnabled;
    private boolean isClientCertAuthenticationAccepted;
    private boolean isHTTPBasicAuthenticationAccepted;

    public SAML2BackChannelSecurityPolicyImpl() {
    }

    public SAML2BackChannelSecurityPolicyImpl(SAML2CfgObject parent) {
        super(parent, RELATIVE_PATH);
    }

    @Override
    protected void readConfiguration() {
        this.isAuthenticationEnabled = Boolean.parseBoolean(this.readProperty(KEY_IS_AUTHENTICATION_ENABLED, "false"));
        this.isClientCertAuthenticationAccepted = Boolean.parseBoolean(this.readProperty(KEY_IS_CLIENT_CERT_AUTHN_ACCEPTED, "false"));
        this.isHTTPBasicAuthenticationAccepted = Boolean.parseBoolean(this.readProperty(KEY_IS_HTTP_BASIC_AUTHN_ACCEPTED, "false"));
        this.isHTTPSRequired = Boolean.parseBoolean(this.readProperty(KEY_IS_HTTPS_REQUIRED, "false"));
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        this.createConfiguration(parent, RELATIVE_PATH);
        this.setProperty(KEY_IS_AUTHENTICATION_ENABLED, this.isAuthenticationEnabled);
        this.setProperty(KEY_IS_CLIENT_CERT_AUTHN_ACCEPTED, this.isClientCertAuthenticationAccepted);
        this.setProperty(KEY_IS_HTTP_BASIC_AUTHN_ACCEPTED, this.isHTTPBasicAuthenticationAccepted);
        this.setProperty(KEY_IS_HTTPS_REQUIRED, this.isHTTPSRequired);
        this.writeConfiguration();
    }

    @Override
    public boolean isAuthenticationEnabled() {
        return this.isAuthenticationEnabled;
    }

    @Override
    public boolean isClientCertAuthenticationAccepted() {
        return this.isClientCertAuthenticationAccepted;
    }

    @Override
    public boolean isHTTPBasicAuthenticationAccepted() {
        return this.isHTTPBasicAuthenticationAccepted;
    }

    @Override
    public boolean isHTTPSRequired() {
        return this.isHTTPSRequired;
    }

    @Override
    public void setAuthenticationEnabled(boolean isRequired) {
        this.isAuthenticationEnabled = isRequired;
    }

    @Override
    public void setClientCertAuthenticationAccepted(boolean isAccepted) {
        this.isClientCertAuthenticationAccepted = isAccepted;
    }

    @Override
    public void setHTTPBasicAuthenticationAccepted(boolean isAccepted) {
        this.isHTTPBasicAuthenticationAccepted = isAccepted;
    }

    @Override
    public void setHTTPSRequired(boolean isRequired) {
        this.isHTTPSRequired = isRequired;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.isHTTPSRequired, this.isAuthenticationEnabled, this.isClientCertAuthenticationAccepted, this.isHTTPBasicAuthenticationAccepted, super.toString());
    }
}

