/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.SAML2AuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.write.SAML2CfgAuthenticationContextSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public class SAML2CfgAuthenticationContextImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2CfgAuthenticationContext,
SAML2CfgAuthenticationContextSetter {
    private static final long serialVersionUID = 1L;
    private static final Location LOCATION = Location.getLocation(SAML2CfgAuthenticationContextImpl.class);
    private static final String TOSTRING_PATTERN = "alias: {0}, name: {1}, is HTTP: {2}, is HTTPS: {3}, is interactive: {4}, is custom: {5}, rank: {6}, cfg path: {7}";
    private static final String KEY_NAME = "name";
    private static final String KEY_ALIAS = "alias";
    private static final String KEY_IS_HTTP = "isHTTP";
    private static final String KEY_IS_HTTPS = "isHTTPS";
    private static final String KEY_IS_INTERACTIVE = "isInteractive";
    private static final String KEY_IS_CUSTOM = "isCustom";
    private static final String KEY_RANK = "rank";
    private String name;
    private String alias;
    private Boolean isHTTP;
    private Boolean isHTTPS;
    private Boolean isInteractive;
    private Boolean isCustom;
    private Integer rank;

    public SAML2CfgAuthenticationContextImpl() {
    }

    public SAML2CfgAuthenticationContextImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        super(parent, subPath, propertySheet);
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        SAML2AuthenticationContext context = SAML2AuthenticationContext.getAuthenticationContextByName(this.name);
        if (context != null) {
            this.setProperty(KEY_IS_CUSTOM, false);
            if (!context.getAlias().equals(this.alias)) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("The alias of the SAML2 standard defined authentication context: {0} cannot be changed. Instead of the user specified alias: {1} will be used: {2}", new Object[]{this.name, this.alias, context.getAlias()});
                }
                this.alias = context.getAlias();
            }
        } else {
            this.setProperty(KEY_IS_CUSTOM, true);
        }
        this.setProperty(KEY_NAME, this.name);
        this.setProperty(KEY_ALIAS, this.alias);
        this.setProperty(KEY_IS_HTTP, this.isHTTP);
        this.setProperty(KEY_IS_HTTPS, this.isHTTPS);
        this.setProperty(KEY_IS_INTERACTIVE, this.isInteractive);
        this.setProperty(KEY_RANK, this.rank);
        super.writeConfiguration();
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        this.name = this.readProperty(KEY_NAME);
        this.alias = this.readProperty(KEY_ALIAS);
        this.isHTTP = this.readBooleanProperty(KEY_IS_HTTP, false);
        this.isHTTPS = this.readBooleanProperty(KEY_IS_HTTPS, false);
        this.isInteractive = this.readBooleanProperty(KEY_IS_INTERACTIVE, false);
        this.isCustom = this.readBooleanProperty(KEY_IS_CUSTOM, false);
        this.rank = this.readIntegerProperty(KEY_RANK);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getRank() {
        return this.rank;
    }

    @Override
    public boolean isCustom() {
        return this.isCustom != null ? this.isCustom : false;
    }

    @Override
    public boolean isHTTP() {
        return this.isHTTP != null ? this.isHTTP : false;
    }

    @Override
    public boolean isHTTPS() {
        return this.isHTTPS != null ? this.isHTTPS : false;
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive != null ? this.isInteractive : false;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void setHTTP(Boolean isHTTP) {
        this.isHTTP = isHTTP;
    }

    @Override
    public void setHTTPS(Boolean isHTTPS) {
        this.isHTTPS = isHTTPS;
    }

    @Override
    public void setInteractive(Boolean isInteractive) {
        this.isInteractive = isInteractive;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setRank(Integer rank) {
        this.rank = rank;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.alias, this.name, this.isHTTP, this.isHTTPS, this.isInteractive, this.isCustom, this.rank, super.toString());
    }
}

