/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgManagement;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.tc.logging.Location;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;

class SAML2CfgClusterNotificator {
    private static final String SIM_TYPE = "SIM";
    private static final String SAML2_CFG_MBEAN_NAME = "saml2.cfg";
    private static final String SAML2_CFG_MBEAN_FULL_OBJECT_NAME = ":name=saml2.cfg,j2eeType=SIM,SAP_J2EEClusterNode=\"\",SAP_J2EECluster=\"\"";
    private static final Location LOCATION = Location.getLocation(SAML2CfgClusterNotificator.class);
    private static String localServerNodeName;
    private MBeanServerConnection mbsc;
    private Set<ObjectName> saml2CfgObjectNames;

    SAML2CfgClusterNotificator() throws SAML2ConfigurationException {
        try {
            this.mbsc = (MBeanServerConnection)new InitialContext().lookup("jmx");
            if (this.mbsc == null) {
                throw new SAML2ConfigurationException("Could not obtain MBean server connection through naming");
            }
            ObjectName saml2CfgObjectName = new ObjectName("*:*,name=saml2.cfg");
            this.saml2CfgObjectNames = this.mbsc.queryNames(saml2CfgObjectName, null);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Total SAML2 configuration MBeans found: " + this.saml2CfgObjectNames.size());
            }
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain SAML2 configuration MBeans", e);
        }
    }

    void prepareForMassConfiguration() throws SAML2ConfigurationException {
        for (ObjectName objectName : this.saml2CfgObjectNames) {
            String nodeName = objectName.getKeyProperty("SAP_J2EEClusterNode");
            if (!nodeName.equals(localServerNodeName)) {
                try {
                    this.mbsc.invoke(objectName, "prepareForMassConfiguration", new Object[0], new String[0]);
                    if (!LOCATION.beDebug()) continue;
                    LOCATION.debugT("MBean: " + objectName + " notified to be prepared for mass configuration");
                }
                catch (Exception e) {
                    LOCATION.traceThrowableT(500, "Could not notified MBean: {0} to be prepared for mass configuration", new Object[]{objectName}, (Throwable)e);
                }
                continue;
            }
            if (!LOCATION.beDebug()) continue;
            LOCATION.debugT("SAML2 configuration MBean: {0} on the local cluster node is skipped", new Object[]{objectName});
        }
    }

    void finishedMassConfiguration() throws SAML2ConfigurationException {
        for (ObjectName objectName : this.saml2CfgObjectNames) {
            String nodeName = objectName.getKeyProperty("SAP_J2EEClusterNode");
            if (!nodeName.equals(localServerNodeName)) {
                try {
                    this.mbsc.invoke(objectName, "finishedMassConfiguration", new Object[0], new String[0]);
                    if (!LOCATION.beDebug()) continue;
                    LOCATION.debugT("MBean: " + objectName + " notified for finished mass configuration");
                }
                catch (Exception e) {
                    LOCATION.traceThrowableT(500, "Could not notified MBean: {0} for finished mass configuration", new Object[]{objectName}, (Throwable)e);
                }
                continue;
            }
            if (!LOCATION.beDebug()) continue;
            LOCATION.debugT("SAML2 configuration MBean: {0} on the local cluster node is skipped", new Object[]{objectName});
        }
    }

    static void registerSAML2CfgManagementMBean() {
        try {
            InitialContext initialContext = new InitialContext();
            MBeanServer mbeanServer = (MBeanServer)initialContext.lookup("jmx");
            ObjectName saml2ManagerObjectName = new ObjectName(SAML2_CFG_MBEAN_FULL_OBJECT_NAME);
            SAML2CfgManagement cfgMBean = new SAML2CfgManagement();
            if (mbeanServer.isRegistered(saml2ManagerObjectName)) {
                mbeanServer.unregisterMBean(saml2ManagerObjectName);
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Old SAML2 configuration mbean is unregistered with name: {0}", new Object[]{saml2ManagerObjectName});
                }
            }
            ObjectInstance result = mbeanServer.registerMBean(cfgMBean, saml2ManagerObjectName);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("SAML2 configuration mbean is registered with name: {0}", new Object[]{saml2ManagerObjectName});
            }
            ObjectName populatedName = result.getObjectName();
            localServerNodeName = populatedName.getKeyProperty("SAP_J2EEClusterNode");
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not registered SAML2 configuration mbean", (Throwable)e);
            throw new RuntimeException("Could not registered SAML2 configuration mbean", e);
        }
    }

    static void unregisterSAML2CfgManagementMBean() {
        block4: {
            try {
                InitialContext initialContext = new InitialContext();
                MBeanServer mbeanServer = (MBeanServer)initialContext.lookup("jmx");
                ObjectName saml2ManagerObjectName = new ObjectName(SAML2_CFG_MBEAN_FULL_OBJECT_NAME);
                if (mbeanServer != null && mbeanServer.isRegistered(saml2ManagerObjectName)) {
                    mbeanServer.unregisterMBean(saml2ManagerObjectName);
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("SAML2 configuration mbean with name: {0} is unregistered", new Object[]{saml2ManagerObjectName});
                    }
                }
            }
            catch (Exception e) {
                if (!LOCATION.beWarning()) break block4;
                LOCATION.traceThrowableT(400, "Could not unregistered SAML2 configuration mbean", (Throwable)e);
            }
        }
    }
}

