/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.enums.SAML2CfgDeletionStatus;
import com.sap.security.saml2.cfg.interfaces.SAML2CfgDeletionReport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SAML2CfgDeletionReportImpl
implements SAML2CfgDeletionReport {
    private Map<String, String> notDeletedKeypairs = new HashMap<String, String>();
    private Map<String, String> notDeletedCertificates = new HashMap<String, String>();
    private Map<String, String> notDeletedDestinations = new HashMap<String, String>();

    @Override
    public SAML2CfgDeletionStatus getDeletionStatus() {
        if (this.notDeletedKeypairs.size() > 0 || this.notDeletedCertificates.size() > 0 || this.notDeletedDestinations.size() > 0) {
            return SAML2CfgDeletionStatus.PARTIAL_KEYSTORE_ENTRIES_AND_OR_DESTINATIONS_DELETION;
        }
        return SAML2CfgDeletionStatus.SUCCESS;
    }

    @Override
    public Map<String, String> getNotDeletedLocalProviderKeypairs() {
        return Collections.unmodifiableMap(this.notDeletedKeypairs);
    }

    @Override
    public Map<String, String> getNotDeletedTrustedProvidersCertificates() {
        return Collections.unmodifiableMap(this.notDeletedCertificates);
    }

    @Override
    public Map<String, String> getNotDeletedTrustedProvidersDestinations() {
        return Collections.unmodifiableMap(this.notDeletedDestinations);
    }

    @Override
    public Map<String, String> getNotDeletedCertificates() {
        return this.notDeletedCertificates;
    }

    @Override
    public Map<String, String> getNotDeletedDestinations() {
        return this.notDeletedDestinations;
    }

    void addNotDeletedLocalProviderKeypair(String notDeletedKeypairName, String reasonMessage) {
        this.notDeletedKeypairs.put(notDeletedKeypairName, reasonMessage);
    }

    void addNotDeletedTrustedProviderCertificate(String notDeletedCertificateName, String reasonMessage) {
        this.notDeletedCertificates.put(notDeletedCertificateName, reasonMessage);
    }

    void addNotDeletedTrustedProviderDestination(String notDeletedDestinationName, String reasonMessage) {
        this.notDeletedDestinations.put(notDeletedDestinationName, reasonMessage);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Deletion report status: ").append((Object)this.getDeletionStatus());
        builder.append("\nNot deleted local provider' keypairs: ").append(this.notDeletedKeypairs);
        builder.append("\nNot deleted trusted providers' certificates: ").append(this.notDeletedCertificates);
        builder.append("\nNot deleted trusted providers' destinations: ").append(this.notDeletedDestinations);
        return builder.toString();
    }
}

