/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgDeletionReportImpl;
import com.sap.security.saml2.cfg.SAML2KeystoreWrapper;
import com.sap.security.saml2.cfg.interfaces.SAML2CfgDeletionReport;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.security.saml2.cfg.util.DestinationUtil;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class SAML2CfgInternalUtils {
    private static final Location LOCATION = Location.getLocation(SAML2CfgInternalUtils.class);

    SAML2CfgInternalUtils() {
    }

    static Set<String> getUsedDestinations(SAML2TrustedProvider trustedProvider) {
        HashSet<String> result = new HashSet<String>();
        Collection<SAML2Endpoint> endpoints = trustedProvider.getAllEndpoints();
        for (SAML2Endpoint endpoint : endpoints) {
            String destinationName = endpoint.getDestinationName();
            if (CfgUtils.isEmpty(destinationName)) continue;
            result.add(destinationName);
        }
        return result;
    }

    static Set<String> getUsedKeypairs(SAML2LocalProvider localProvider) {
        HashSet<String> result = new HashSet<String>(2);
        String keypairName = localProvider.getSigningKeyPairName();
        if (!CfgUtils.isEmpty(keypairName)) {
            result.add(keypairName);
        }
        if (!CfgUtils.isEmpty(keypairName = localProvider.getEncryptionKeyPairName())) {
            result.add(keypairName);
        }
        return result;
    }

    static Set<String> getUsedCertificates(SAML2TrustedProvider trustedProvider) {
        HashSet<String> result = new HashSet<String>(3);
        String certificateName = trustedProvider.getSigningCertificateName();
        if (!CfgUtils.isEmpty(certificateName)) {
            result.add(certificateName);
        }
        if (!CfgUtils.isEmpty(certificateName = trustedProvider.getSecondarySigningCertificateName())) {
            result.add(certificateName);
        }
        if (!CfgUtils.isEmpty(certificateName = trustedProvider.getEncryptionCertificateName())) {
            result.add(certificateName);
        }
        return result;
    }

    static SAML2CfgDeletionReport deleteKeypairs(String keystoreView, Collection<String> keypairs, SAML2CfgDeletionReportImpl report) {
        if (keypairs != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Triggered deletion of keypairs with names: {0} from keystore view: {1}", new Object[]{keypairs, keystoreView});
            }
            for (String keypairName : keypairs) {
                try {
                    SAML2KeystoreWrapper.getInstance().deleteKeystoreEntry(keystoreView, keypairName);
                }
                catch (Exception e) {
                    if (LOCATION.beWarning()) {
                        LOCATION.traceThrowableT(400, "Could not delete keypair with name: {0} from keystore view: {1}", new Object[]{keypairName, keystoreView}, (Throwable)e);
                    }
                    report.addNotDeletedLocalProviderKeypair(keypairName, e.getMessage());
                }
            }
        }
        return report;
    }

    static SAML2CfgDeletionReport deleteCertificates(String keystoreView, Collection<String> certificates, SAML2CfgDeletionReportImpl report) {
        if (certificates != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Triggered deletion of certificates with names: {0} from keystore view: {1}", new Object[]{certificates, keystoreView});
            }
            for (String certificateName : certificates) {
                try {
                    SAML2KeystoreWrapper.getInstance().deleteKeystoreEntry(keystoreView, certificateName);
                }
                catch (Exception e) {
                    if (LOCATION.beWarning()) {
                        LOCATION.traceThrowableT(400, "Could not delete certificate with name: {0} from keystore view: {1}", new Object[]{certificateName, keystoreView}, (Throwable)e);
                    }
                    report.addNotDeletedTrustedProviderCertificate(certificateName, e.getMessage());
                }
            }
        }
        return report;
    }

    static SAML2CfgDeletionReport deleteDestinations(Collection<String> destinations, SAML2CfgDeletionReportImpl report) {
        if (destinations != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Triggered deletion of destinations with names: {0}", new Object[]{destinations});
            }
            for (String destinationName : destinations) {
                try {
                    DestinationUtil.deleteDestination(destinationName);
                }
                catch (Exception e) {
                    if (LOCATION.beWarning()) {
                        LOCATION.traceThrowableT(400, "Could not delete destination with name: {0}", new Object[]{destinationName}, (Throwable)e);
                    }
                    report.addNotDeletedTrustedProviderDestination(destinationName, e.getMessage());
                }
            }
        }
        return report;
    }
}

