/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgManagementMBean;
import com.sap.security.saml2.cfg.SAML2GlobalConfigImpl;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.tc.logging.Location;

public class SAML2CfgManagement
implements SAML2CfgManagementMBean {
    private static final Location LOCATION = Location.getLocation(SAML2CfgManagement.class);

    @Override
    public void finishedMassConfiguration() {
        block3: {
            try {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Received notification that mass configuration is finished. Initialize SAML2 global configuration");
                }
                SAML2GlobalConfigImpl.getInstance().initGlobalConfiguration();
            }
            catch (SAML2ConfigurationException e) {
                if (!LOCATION.beError()) break block3;
                LOCATION.traceThrowableT(500, "Could not initialize SAML2GlobalConfig after finished mass configuration", (Throwable)e);
            }
        }
    }

    @Override
    public void prepareForMassConfiguration() {
        block3: {
            try {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Received notification that mass configuration is going to be applied. Destroy current SAML2 global configuration");
                }
                SAML2GlobalConfigImpl.getInstance().destroyGlobalConfiguration();
            }
            catch (SAML2ConfigurationException e) {
                if (!LOCATION.beError()) break block3;
                LOCATION.traceThrowableT(500, "Could not destroy SAML2GlobalConfig to be prepeared for mass configuration", (Throwable)e);
            }
        }
    }
}

