/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.SAML2PredefinedUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.write.SAML2CfgUMEAttributeSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public class SAML2CfgUMEAttributeImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2CfgUMEAttribute,
SAML2CfgUMEAttributeSetter {
    private static final long serialVersionUID = 1L;
    private static final Location LOCATION = Location.getLocation(SAML2CfgUMEAttributeImpl.class);
    private static final String TOSTRING_PATTERN = "alias: {0}, name: {1}, namespace: {2}, is custom: {3}, cfg path: {4}";
    private static final String KEY_ALIAS = "alias";
    private static final String KEY_NAME = "name";
    private static final String KEY_NAMESPACE = "namespace";
    private static final String KEY_IS_CUSTOM = "isCustom";
    private String alias;
    private String name;
    private String namespace;
    private Boolean isCustom;

    public SAML2CfgUMEAttributeImpl() {
    }

    public SAML2CfgUMEAttributeImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        super(parent, subPath, propertySheet);
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        if (SAML2PredefinedUMEAttribute.getUMEAttributeByAlias(this.alias) != null) {
            this.setProperty(KEY_IS_CUSTOM, false);
        } else {
            this.setProperty(KEY_IS_CUSTOM, true);
        }
        this.setProperty(KEY_ALIAS, this.alias);
        this.setProperty(KEY_NAME, this.name);
        this.setProperty(KEY_NAMESPACE, this.namespace);
        super.writeConfiguration();
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        this.alias = this.readProperty(KEY_ALIAS);
        this.name = this.readProperty(KEY_NAME);
        this.namespace = this.readProperty(KEY_NAMESPACE);
        this.isCustom = this.readBooleanProperty(KEY_IS_CUSTOM, false);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isCustom() {
        return this.isCustom != null ? this.isCustom : false;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.alias, this.name, this.namespace, this.isCustom, super.toString());
    }
}

