/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2LocalProvidersConfigImpl;
import com.sap.security.saml2.cfg.SAML2PoliciesConfigImpl;
import com.sap.security.saml2.cfg.SAML2TrustedIdPsConfigImpl;
import com.sap.security.saml2.cfg.SAML2TrustedSPsConfigImpl;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.cfg.interfaces.SAML2LocalProvidersConfig;
import com.sap.security.saml2.cfg.interfaces.SAML2PoliciesConfig;
import com.sap.security.saml2.cfg.interfaces.SAML2TrustedIdPsConfig;
import com.sap.security.saml2.cfg.interfaces.SAML2TrustedSPsConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataTrustedIdP;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataTrustedProvider;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataTrustedSP;
import com.sap.security.saml2.cfg.storage.CfgPropertySetter;
import com.sap.tc.logging.Location;
import java.util.List;

public final class SAML2ConfigImpl
extends SAML2CfgObject
implements SAML2Config {
    private static final Location LOCATION = Location.getLocation(SAML2ConfigImpl.class);
    static final String CFG_SHEET_NAME = "additional_config";
    private static final String KEY_NAME = "name";
    private SAML2LocalProvidersConfigImpl localProvidersConfiguration;
    private SAML2TrustedIdPsConfigImpl trustedIdPsConfiguration;
    private SAML2TrustedSPsConfigImpl trustedSPsConfiguration;
    private SAML2PoliciesConfigImpl policiesConfiguration;
    private String name;
    private boolean isDefaultSAML2Config;

    SAML2ConfigImpl(String cfgPath, boolean isDefaultSAML2Config) throws SAML2ConfigurationException {
        super(cfgPath, CFG_SHEET_NAME, true);
        this.isDefaultSAML2Config = isDefaultSAML2Config;
        this.initConfigurationObjects();
        this.name = this.getPropertyValue(KEY_NAME, null).getValue();
    }

    SAML2ConfigImpl(String cfgPath, String name) throws SAML2ConfigurationException {
        super(cfgPath, CFG_SHEET_NAME, true);
        this.name = name;
        this.isDefaultSAML2Config = false;
        try {
            this.createAndSetAnonymousSubCfg();
            CfgPropertySetter propertySetter = this.getPropertySetter();
            propertySetter.setProperty(KEY_NAME, name);
            this.write(propertySetter);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not create additional SAML2 configuration with name: " + name, e);
        }
        this.initConfigurationObjects();
    }

    private void initConfigurationObjects() throws SAML2ConfigurationException {
        this.localProvidersConfiguration = new SAML2LocalProvidersConfigImpl(this);
        this.trustedIdPsConfiguration = new SAML2TrustedIdPsConfigImpl(this);
        this.trustedSPsConfiguration = new SAML2TrustedSPsConfigImpl(this);
        this.policiesConfiguration = new SAML2PoliciesConfigImpl(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDefaultSAML2Config() {
        return this.isDefaultSAML2Config;
    }

    void destroy() {
        if (this.localProvidersConfiguration != null) {
            this.localProvidersConfiguration.destroy();
        }
        if (this.trustedIdPsConfiguration != null) {
            this.trustedIdPsConfiguration.destroy();
        }
        if (this.trustedSPsConfiguration != null) {
            this.trustedSPsConfiguration.destroy();
        }
        if (this.policiesConfiguration != null) {
            this.policiesConfiguration.destroy();
        }
    }

    @Override
    public SAML2LocalProvidersConfig getLocalProvidersConfiguration() {
        return this.localProvidersConfiguration;
    }

    @Override
    public SAML2TrustedIdPsConfig getTrustedIdPsConfiguration() {
        return this.trustedIdPsConfiguration;
    }

    @Override
    public SAML2TrustedSPsConfig getTrustedSPsConfiguration() {
        return this.trustedSPsConfiguration;
    }

    @Override
    public SAML2PoliciesConfig getPoliciesConfiguration() {
        return this.policiesConfiguration;
    }

    @Override
    public SAML2TrustedProvider getTrustedProvider(String name) {
        SAML2TrustedSP trustedSP = this.getTrustedSPsConfiguration().getTrustedSP(name);
        SAML2TrustedIdP trustedIdP = this.getTrustedIdPsConfiguration().getTrustedIdP(name);
        if (trustedSP != null && trustedIdP != null) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Found both trusted SP and trusted IdP with the specified name: {0}. Will be returned the trusted SP.", new Object[]{name});
            }
            return trustedSP;
        }
        if (trustedSP != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Found trusted SP with the specified name: {0}", new Object[]{name});
            }
            return trustedSP;
        }
        if (trustedIdP != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Found trusted IdP with the specified name: {0}", new Object[]{name});
            }
            return trustedIdP;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Neither trusted SP nor trusted IdP has been found with the specified name: {0}", new Object[]{name});
        }
        return null;
    }

    @Override
    public SAML2TrustedProvider getTrustedProviderByID(byte[] id) {
        SAML2TrustedSP trustedSP = this.getTrustedSPsConfiguration().getTrustedSPByID(id);
        SAML2TrustedIdP trustedIdP = this.getTrustedIdPsConfiguration().getTrustedIdPByID(id);
        if (trustedSP != null && trustedIdP != null) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Found both trusted SP and trusted IdP with the specified id: {0}. Will be returned the trusted SP.", new Object[]{id});
            }
            return trustedSP;
        }
        if (trustedSP != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Found trusted SP with the specified id: {0}", new Object[]{id});
            }
            return trustedSP;
        }
        if (trustedIdP != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Found trusted IdP with the specified id: {0}", new Object[]{id});
            }
            return trustedIdP;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Neither trusted SP nor trusted IdP has been found with the specified id: {0}", new Object[]{id});
        }
        return null;
    }

    @Override
    public void createTrustedProviders(List<SAML2MetadataTrustedProvider> trustedProviders) throws SAML2ConfigurationException {
        if (trustedProviders != null) {
            for (SAML2MetadataTrustedProvider trustedProvider : trustedProviders) {
                if (trustedProvider instanceof SAML2MetadataTrustedSP) {
                    this.getTrustedSPsConfiguration().createTrustedSP((SAML2MetadataTrustedSP)trustedProvider);
                    continue;
                }
                if (trustedProvider instanceof SAML2MetadataTrustedIdP) {
                    this.getTrustedIdPsConfiguration().createTrustedIdP((SAML2MetadataTrustedIdP)trustedProvider);
                    continue;
                }
                if (!LOCATION.beDebug()) continue;
                LOCATION.debugT("Unsupported metadata representation of the trusted provider: {0}. Could be either: {1} or {2}.", new Object[]{trustedProvider != null ? trustedProvider.getClass() : null, SAML2MetadataTrustedSP.class, SAML2MetadataTrustedIdP.class});
            }
        }
    }
}

