/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.core.server.destinations.api.HTTPDestination;
import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2Service;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.write.SAML2EndpointSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.DestinationUtil;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public class SAML2EndpointImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2Endpoint,
SAML2EndpointSetter {
    private static final Location LOCATION = Location.getLocation(SAML2EndpointImpl.class);
    private static final String TOSTRING_PATTERN = "Service: {0}, binding: {1}, index: {2}, default: {3}, location: {4}, response location: {5}, destination name: {6}, cfg path: {7}";
    private static final String KEY_SERVICE = "service";
    private static final String KEY_BINDING = "binding";
    private static final String KEY_INDEX = "index";
    private static final String KEY_DEFAULT = "default";
    private static final String KEY_LOCATION = "location";
    private static final String KEY_RESPONSE_LOCATION = "response_location";
    private static final String KEY_DESTINATION_NAME = "destination_name";
    private SAML2Service service;
    private SAML2Binding binding;
    private Integer index;
    private Boolean isDefault;
    private String location;
    private String responseLocation;
    private String destinationName;

    public SAML2EndpointImpl() {
    }

    public SAML2EndpointImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        super(parent, subPath, propertySheet);
    }

    @Override
    public SAML2Binding getBinding() {
        return this.binding;
    }

    @Override
    public HTTPDestination getDestination() throws SAML2ConfigurationException {
        if (this.destinationName != null) {
            try {
                return DestinationUtil.getDestination(this.destinationName);
            }
            catch (Exception exception) {
                throw new SAML2ConfigurationException("Could not obtain destination with name: " + this.destinationName);
            }
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Could not obtain destination, because there is not configured destination name");
        }
        return null;
    }

    @Override
    public String getDestinationName() {
        return this.destinationName;
    }

    @Override
    public int getIndex() {
        return this.index != null ? this.index : -1;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getResponseLocation() {
        return this.responseLocation;
    }

    @Override
    public SAML2Service getService() {
        return this.service;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault != null ? this.isDefault : false;
    }

    @Override
    public void setBinding(SAML2Binding binding) {
        this.binding = binding;
    }

    @Override
    public void setDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public void setDestinationName(String name) {
        this.destinationName = name;
    }

    @Override
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public void setResponseLocation(String responseLocation) {
        this.responseLocation = responseLocation;
    }

    @Override
    public void setService(SAML2Service service) {
        this.service = service;
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        if (this.service != null) {
            this.setProperty(KEY_SERVICE, this.service.getName());
        }
        if (this.binding != null) {
            this.setProperty(KEY_BINDING, this.binding.getName());
        }
        this.setProperty(KEY_INDEX, this.index);
        this.setProperty(KEY_DEFAULT, this.isDefault);
        this.setProperty(KEY_LOCATION, this.location);
        this.setProperty(KEY_RESPONSE_LOCATION, this.responseLocation);
        this.setProperty(KEY_DESTINATION_NAME, this.destinationName);
        super.writeConfiguration();
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        block3: {
            this.service = SAML2Service.getService(this.readProperty(KEY_SERVICE));
            this.binding = SAML2Binding.getBinding(this.readProperty(KEY_BINDING));
            String dbValue = this.readProperty(KEY_INDEX);
            if (dbValue != null && dbValue.length() > 0) {
                try {
                    this.index = Integer.parseInt(dbValue);
                }
                catch (Exception exception) {
                    if (!LOCATION.beWarning()) break block3;
                    LOCATION.warningT("Configured value for endpoint index is not a number: {0}", new Object[]{dbValue});
                }
            }
        }
        this.isDefault = Boolean.parseBoolean(this.readProperty(KEY_DEFAULT, "false"));
        this.location = this.readProperty(KEY_LOCATION);
        this.responseLocation = this.readProperty(KEY_RESPONSE_LOCATION);
        this.destinationName = this.readProperty(KEY_DESTINATION_NAME);
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.service, this.binding, this.index, this.isDefault, this.location, this.responseLocation, this.destinationName, super.toString());
    }
}

