/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2SubCfgObjectBase;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SAML2EntranceLocationMappingsImpl
extends SAML2SubCfgObjectBase {
    private static final String RELATIVE_PATH = "entrance_locations";
    private Map<String, String> mappings;

    public SAML2EntranceLocationMappingsImpl() {
    }

    public SAML2EntranceLocationMappingsImpl(SAML2CfgObject parent) {
        super(parent, RELATIVE_PATH);
    }

    @Override
    protected void readConfiguration() {
        String[] keys;
        this.mappings = new HashMap<String, String>();
        String[] stringArray = keys = this.getCfgPropertySheetKeys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = this.readProperty(key);
            this.mappings.put(key, value);
            ++n2;
        }
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        this.createConfiguration(parent, RELATIVE_PATH);
        this.deleteCfgObject(this);
        if (this.mappings != null && this.mappings.size() > 0) {
            Set<String> keys = this.mappings.keySet();
            for (String key : keys) {
                String value = this.mappings.get(key);
                this.setProperty(key, value);
            }
        }
        this.writeConfiguration();
    }

    public String getEntranceLocation(String key) {
        return this.mappings.get(key);
    }

    public Map<String, String> getEntranceLocationMappings() {
        return this.mappings;
    }

    public void setEntranceLocationMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    @Override
    public String toString() {
        return "Entrance location mappings: " + this.mappings;
    }
}

