/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.interfaces.read.SAML2ExtensionSupplierDescriptor;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ExtensionSupplierSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.lib.extensions.SAML2MessageType;
import com.sap.tc.logging.Location;

public class SAML2ExtensionSupplierDescriptorImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2ExtensionSupplierDescriptor,
SAML2ExtensionSupplierSetter {
    private static final Location LOCATION = Location.getLocation(SAML2ExtensionSupplierDescriptorImpl.class);
    private static final String KEY_NAME = "supplier_name";
    private static final String KEY_TYPE = "message_type";
    private String name;
    private SAML2MessageType type;

    public SAML2ExtensionSupplierDescriptorImpl() {
    }

    public SAML2ExtensionSupplierDescriptorImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        super(parent, subPath, propertySheet);
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        block2: {
            this.name = this.readProperty(KEY_NAME);
            try {
                this.type = SAML2MessageType.valueOf((String)this.readProperty(KEY_TYPE));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!LOCATION.beWarning()) break block2;
                LOCATION.warningT("Unknown message type for supplier descriptor {0}: {1} ", new Object[]{this.name, this.readProperty(KEY_TYPE)});
            }
        }
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        this.setProperty(KEY_NAME, this.name);
        this.setProperty(KEY_TYPE, this.type.name());
        super.writeConfiguration();
    }

    public String getName() {
        return this.name;
    }

    public SAML2MessageType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return "[supplier: " + this.name + ", type: " + this.type + "]";
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setType(SAML2MessageType type) {
        this.type = type;
    }
}

