/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2ModifiableExternalCDCReaderImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableCfgObjectBase;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2ExternalCDCReader;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableExternalCDCReader;
import com.sap.security.saml2.cfg.storage.CfgChangeEvent;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.storage.StorageChangedListener;
import com.sap.tc.logging.Location;
import java.util.List;

public class SAML2ExternalCDCReaderImpl
extends SAML2UpdateableCfgObjectBase
implements SAML2ExternalCDCReader,
StorageChangedListener {
    private static final Location LOCATION = Location.getLocation(SAML2ExternalCDCReaderImpl.class);
    protected static final String CFG_PATH = "external_cdc_reader";
    protected static final String CFG_SHEET_NAME = "cfg";
    protected static final String KEY_ALLOWED_REDIRECT_URLS = "allowed_redirect_urls";

    public SAML2ExternalCDCReaderImpl() {
        super(CFG_PATH, CFG_SHEET_NAME);
        try {
            this.registerAsStorageListener(this);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not register storage listener for SAML2 external CDC reader service settings with path: {0}", new Object[]{this.getCfgPath()}, (Throwable)e);
        }
    }

    @Override
    public void storageChanged(CfgChangeEvent event) {
        this.update();
    }

    @Override
    protected synchronized void cleanCachedObjects() {
    }

    void deleteExternalCDCReaderSettings() throws SAML2ConfigurationException {
        try {
            this.deleteCfgObject(this);
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not external CDC writer settings.", e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nExternal CDC reader settings cfg path: ").append(super.toString());
        builder.append("\nAllowed for redirect locations: ").append(this.getRedirectURLWhitelist());
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public SAML2ModifiableExternalCDCReader getModifiableExternalCDCReader() throws SAML2ConfigurationException {
        return new SAML2ModifiableExternalCDCReaderImpl(this);
    }

    @Override
    public List<String> getRedirectURLWhitelist() {
        return this.readMultiValueProperty(KEY_ALLOWED_REDIRECT_URLS);
    }
}

