/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgFactory;
import com.sap.security.saml2.cfg.SAML2ModifiableExternalCDCWriterImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableCfgObjectBase;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.cfg.interfaces.SAML2GlobalConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2ExternalCDCWriter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableExternalCDCWriter;
import com.sap.security.saml2.cfg.storage.CfgChangeEvent;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.storage.StorageChangedListener;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SAML2ExternalCDCWriterImpl
extends SAML2UpdateableCfgObjectBase
implements SAML2ExternalCDCWriter,
StorageChangedListener {
    private static final Location LOCATION = Location.getLocation(SAML2ExternalCDCWriterImpl.class);
    protected static final String CFG_PATH = "external_cdc_writer";
    protected static final String CFG_SHEET_NAME = "cfg";
    protected static final String KEY_DOMAIN_RELAXATION_LEVEL = "domain_relax_level";
    protected static final String KEY_CDC_MAX_AGE = "cdc_max_age";
    protected static final String KEY_ALLOWED_ADDITIONAL_IDPS = "allowed_additional_idps";
    protected static final String KEY_ALLOWED_REDIRECT_URLS = "allowed_redirect_url";

    public SAML2ExternalCDCWriterImpl() {
        super(CFG_PATH, CFG_SHEET_NAME);
        try {
            this.registerAsStorageListener(this);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not register storage listener for SAML2 external CDC writer service settings with path: {0}", new Object[]{this.getCfgPath()}, (Throwable)e);
        }
    }

    @Override
    public List<String> getAdditionalIdPs() {
        return this.readMultiValueProperty(KEY_ALLOWED_ADDITIONAL_IDPS);
    }

    @Override
    public synchronized List<String> getAllAllowedIdPs() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getLocalIdPs());
        result.addAll(this.getAdditionalIdPs());
        return Collections.unmodifiableList(result);
    }

    @Override
    public int getDomainRelaxationLevel() {
        return this.readIntProperty(KEY_DOMAIN_RELAXATION_LEVEL, 1);
    }

    @Override
    public List<String> getLocalIdPs() {
        ArrayList<String> result;
        block3: {
            result = new ArrayList<String>();
            try {
                SAML2GlobalConfig globalConfig = SAML2CfgFactory.getSAML2GlobalConfig();
                Collection<SAML2Config> saml2Configs = globalConfig.getSAML2Configurations();
                for (SAML2Config config : saml2Configs) {
                    String idpName;
                    if (!config.getLocalProvidersConfiguration().isIdentityProviderEnabled() || CfgUtils.isEmpty(idpName = config.getLocalProvidersConfiguration().getLocalIdP().getName())) continue;
                    result.add(idpName);
                }
            }
            catch (SAML2ConfigurationException e) {
                if (!LOCATION.beWarning()) break block3;
                LOCATION.traceThrowableT(400, "Could not obtain the local SAML2 configuration. Local IdPs will not be treated as allowed for this CDC writing service", (Throwable)e);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<String> getRedirectURLWhitelist() {
        return this.readMultiValueProperty(KEY_ALLOWED_REDIRECT_URLS);
    }

    @Override
    public int getCDCMaxAge() {
        return this.readIntProperty(KEY_CDC_MAX_AGE, -1);
    }

    @Override
    public SAML2ModifiableExternalCDCWriter getModifiableExternalCDCWriter() throws SAML2ConfigurationException {
        return new SAML2ModifiableExternalCDCWriterImpl(this);
    }

    @Override
    public void storageChanged(CfgChangeEvent event) {
        this.update();
    }

    @Override
    protected synchronized void cleanCachedObjects() {
    }

    void deleteExternalCDCWriterSettings() throws SAML2ConfigurationException {
        try {
            this.deleteCfgObject(this);
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not external CDC writer settings.", e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nExternal CDC writer settings cfg path: ").append(super.toString());
        builder.append("\nDomain relaxation level: ").append(this.getDomainRelaxationLevel());
        builder.append("\nCDC Max Age: ").append(this.getCDCMaxAge());
        builder.append("\nLocal allowed IdPs: ").append(this.getLocalIdPs());
        builder.append("\nAdditionally allowed IdPs: ").append(this.getAdditionalIdPs());
        builder.append("\nAllowed redirect URLs: ").append(this.getRedirectURLWhitelist());
        builder.append("\n");
        return builder.toString();
    }
}

