/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgClusterNotificator;
import com.sap.security.saml2.cfg.SAML2CfgDeletionReportImpl;
import com.sap.security.saml2.cfg.SAML2CfgInternalUtils;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2ConfigImpl;
import com.sap.security.saml2.cfg.SAML2ExternalCDCReaderImpl;
import com.sap.security.saml2.cfg.SAML2ExternalCDCWriterImpl;
import com.sap.security.saml2.cfg.SAML2GlobalSettingsImpl;
import com.sap.security.saml2.cfg.SAML2KeystoreWrapper;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2CfgDeletionReport;
import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.cfg.interfaces.SAML2GlobalConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2ExternalCDCReader;
import com.sap.security.saml2.cfg.interfaces.read.SAML2ExternalCDCWriter;
import com.sap.security.saml2.cfg.interfaces.read.SAML2GlobalSettings;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.cfg.security.SAML2CfgSecurityManager;
import com.sap.security.saml2.cfg.storage.CfgChangeEvent;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.storage.StorageChangedListener;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class SAML2GlobalConfigImpl
extends SAML2CfgObject
implements SAML2GlobalConfig,
StorageChangedListener {
    private static final String DEFAULT_SAML2_CONFIG = "default";
    private static final String ADDITIONAL_SAML2_CONFIG = "additional";
    private static final Location LOCATION = Location.getLocation(SAML2GlobalConfigImpl.class);
    private static SAML2GlobalConfigImpl instance;
    private SAML2ConfigImpl defaultSAML2Configuration;
    private Map<String, SAML2Config> additionalSAML2Configurations = new HashMap<String, SAML2Config>();
    private Map<String, SAML2ConfigImpl> updateableSAML2Configurations = new HashMap<String, SAML2ConfigImpl>();
    private Map<String, String> saml2ConfigurationNames = new HashMap<String, String>();
    private SAML2GlobalSettingsImpl globalSettings;
    private SAML2ExternalCDCWriterImpl externalCDCWriterSettings;
    private SAML2ExternalCDCReaderImpl externalCDCReaderSettings;

    private SAML2GlobalConfigImpl() throws SAML2ConfigurationException {
        try {
            this.initGlobalConfiguration();
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not initialize SAML2 global configuration", (Throwable)e);
            throw new SAML2ConfigurationException("Could not initialize SAML2 global configuration", e);
        }
    }

    static SAML2GlobalConfigImpl getInstance() throws SAML2ConfigurationException {
        if (instance == null) {
            SAML2GlobalConfigImpl.createInstance();
        }
        return instance;
    }

    private static synchronized void createInstance() throws SAML2ConfigurationException {
        if (instance == null) {
            instance = new SAML2GlobalConfigImpl();
        }
    }

    @Override
    public synchronized void refresh() throws SAML2ConfigurationException {
        if (LOCATION.beInfo()) {
            LOCATION.infoT("SAML2 configuration reload process is triggered");
        }
        this.destroyGlobalConfiguration();
        this.initGlobalConfiguration();
    }

    synchronized void initGlobalConfiguration() throws SAML2ConfigurationException {
        this.defaultSAML2Configuration = new SAML2ConfigImpl(DEFAULT_SAML2_CONFIG, true);
        this.globalSettings = new SAML2GlobalSettingsImpl();
        this.externalCDCWriterSettings = new SAML2ExternalCDCWriterImpl();
        this.externalCDCReaderSettings = new SAML2ExternalCDCReaderImpl();
        this.loadAllAdditionalSAML2Configurations();
        try {
            this.registerAsStorageListenerForSubPath(this, ADDITIONAL_SAML2_CONFIG);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not register storage listener for Global SAML2 configurations", (Throwable)e);
        }
        HashSet<String> saml2KeystoreViews = new HashSet<String>();
        saml2KeystoreViews.add(this.defaultSAML2Configuration.getLocalProvidersConfiguration().getLocalProvider().getKeyStoreViewName());
        saml2KeystoreViews.add(this.defaultSAML2Configuration.getLocalProvidersConfiguration().getLocalProvider().getTrustedCAsViewName());
        for (SAML2Config saml2Config : this.additionalSAML2Configurations.values()) {
            saml2KeystoreViews.add(saml2Config.getLocalProvidersConfiguration().getLocalProvider().getKeyStoreViewName());
            saml2KeystoreViews.add(saml2Config.getLocalProvidersConfiguration().getLocalProvider().getTrustedCAsViewName());
        }
        for (String saml2KeystoreView : saml2KeystoreViews) {
            this.prepareKeystoreViewForSAML2Usage(saml2KeystoreView);
        }
    }

    private void prepareKeystoreViewForSAML2Usage(String keystoreView) {
        block7: {
            if (keystoreView != null && keystoreView.length() > 0) {
                block6: {
                    try {
                        SAML2KeystoreWrapper.getInstance().grantKeystorePermissions(keystoreView);
                    }
                    catch (Exception e) {
                        if (!LOCATION.beWarning()) break block6;
                        LOCATION.traceThrowableT(400, "Could not grant permissions for keystore view: {0}. SAML2 Components might not be able to access it.", new Object[]{keystoreView}, (Throwable)e);
                    }
                }
                try {
                    if (!SAML2KeystoreWrapper.getInstance().existKeystoreView(keystoreView)) {
                        SAML2KeystoreWrapper.getInstance().createView(keystoreView);
                    }
                }
                catch (Exception e) {
                    if (!LOCATION.beWarning()) break block7;
                    LOCATION.traceThrowableT(400, "Could not ensure existence of the keystore view: {0}", new Object[]{keystoreView}, (Throwable)e);
                }
            }
        }
    }

    synchronized void destroyGlobalConfiguration() throws SAML2ConfigurationException {
        try {
            this.unregisterAllConfigurationChangedListener();
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not unregister all configuration changed listeners", e);
        }
        this.additionalSAML2Configurations.clear();
        this.updateableSAML2Configurations.clear();
        this.saml2ConfigurationNames.clear();
    }

    private synchronized void addAdditionalSAML2Configuration(String name, String cfgPath, SAML2ConfigImpl saml2Config) {
        this.additionalSAML2Configurations.put(name, saml2Config);
        this.updateableSAML2Configurations.put(cfgPath, saml2Config);
        this.saml2ConfigurationNames.put(cfgPath, name);
    }

    @Override
    public synchronized SAML2Config getDefaultSAML2Configuration() {
        return this.defaultSAML2Configuration;
    }

    @Override
    public synchronized SAML2Config getSAML2Configuration(String name) {
        return this.additionalSAML2Configurations.get(name);
    }

    @Override
    public synchronized Collection<SAML2Config> getSAML2Configurations() {
        ArrayList<SAML2Config> configs = new ArrayList<SAML2Config>();
        configs.add(this.defaultSAML2Configuration);
        configs.addAll(this.additionalSAML2Configurations.values());
        return configs;
    }

    @Override
    public synchronized Collection<String> getSAML2ConfigurationNames() {
        return this.additionalSAML2Configurations.keySet();
    }

    @Override
    public SAML2GlobalSettings getGlobalSettings() {
        return this.globalSettings;
    }

    @Override
    public SAML2ExternalCDCWriter getExternalCDCWriterSettings() {
        return this.externalCDCWriterSettings;
    }

    @Override
    public SAML2ExternalCDCReader getExternalCDCReaderSettings() {
        return this.externalCDCReaderSettings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void deleteSAML2Configuration(String name) throws SAML2ConfigurationException {
        SAML2CfgSecurityManager.getInstance().checkWritePermission();
        SAML2ConfigImpl saml2Config = (SAML2ConfigImpl)this.additionalSAML2Configurations.get(name);
        if (saml2Config == null) throw new SAML2ConfigurationException("SAML2 configuration with name: " + name + " does not exists");
        try {
            saml2Config.destroy();
            this.deleteCfgObject(saml2Config);
            this.additionalSAML2Configurations.remove(name);
            this.updateableSAML2Configurations.remove(saml2Config.getCfgPath());
            this.saml2ConfigurationNames.remove(saml2Config.getCfgPath());
            SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001018", (String)"Additional SAML2 configuration with name: [{0}] was entirely deleted.", (Object[])new Object[]{name});
            if (!LOCATION.beDebug()) return;
            LOCATION.debugT("SAML2 configuration with name: {0} and cfg path: {1} is deleted.", new Object[]{name, saml2Config.getCfgPath()});
            return;
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not delete SAML2 configuration with name: " + name, e);
        }
    }

    public synchronized void exportSAML2Configuration(String destinationFilePath) throws SAML2ConfigurationException {
        try {
            this.exportConfiguration(destinationFilePath);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not export SAML2 configuration to file: " + destinationFilePath, e);
        }
    }

    public synchronized void importSAML2Configuration(String sourceFilePath) throws SAML2ConfigurationException {
        SAML2CfgClusterNotificator clusterNotificator;
        block8: {
            SAML2CfgSecurityManager.getInstance().checkWritePermission();
            clusterNotificator = null;
            try {
                clusterNotificator = new SAML2CfgClusterNotificator();
            }
            catch (Exception e) {
                if (!LOCATION.beError()) break block8;
                LOCATION.traceThrowableT(500, "Could not initialize the cluster notificator. SAML2 configuration on the other cluster nodes will be outdated", (Throwable)e);
            }
        }
        this.destroyGlobalConfiguration();
        if (clusterNotificator != null) {
            clusterNotificator.prepareForMassConfiguration();
        }
        this.deleteCfgPath(DEFAULT_SAML2_CONFIG);
        this.deleteCfgPath(ADDITIONAL_SAML2_CONFIG);
        if (this.globalSettings != null) {
            this.globalSettings.deleteGlobalSettings();
        }
        if (this.externalCDCWriterSettings != null) {
            this.externalCDCWriterSettings.deleteExternalCDCWriterSettings();
        }
        try {
            this.importConfiguration(sourceFilePath);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not import SAML2 configuration from file: " + sourceFilePath, e);
        }
        this.initGlobalConfiguration();
        if (clusterNotificator != null) {
            clusterNotificator.finishedMassConfiguration();
        }
    }

    private void deleteCfgPath(String path) throws SAML2ConfigurationException {
        try {
            SAML2CfgObject forDelete = new SAML2CfgObject(path, null, true){};
            this.deleteCfgObject(forDelete);
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not delete configuration node: " + path, e);
        }
    }

    @Override
    public synchronized void deleteAllSAML2Configurations() throws SAML2ConfigurationException {
        SAML2CfgSecurityManager.getInstance().checkWritePermission();
        this.deleteDefaultSAML2Configuration();
        this.deleteAllAdditionalSAML2Configurations();
        if (this.globalSettings != null) {
            this.globalSettings.deleteGlobalSettings();
        }
        if (this.externalCDCWriterSettings != null) {
            this.externalCDCWriterSettings.deleteExternalCDCWriterSettings();
        }
    }

    @Override
    public synchronized void deleteDefaultSAML2Configuration() throws SAML2ConfigurationException {
        SAML2CfgSecurityManager.getInstance().checkWritePermission();
        this.defaultSAML2Configuration.destroy();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Configuration changed listeners for default configuration are unregistered");
        }
        try {
            this.deleteCfgObject(this.defaultSAML2Configuration);
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not delete the default SAML2 configuration from the DB", e);
        }
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001017", (String)"Default SAML2 configuration was entirely deleted.");
        this.defaultSAML2Configuration = new SAML2ConfigImpl(DEFAULT_SAML2_CONFIG, true);
    }

    @Override
    public SAML2CfgDeletionReport deleteDefaultSAML2Configuration(boolean deleteLocalProviderKeypairs, boolean deleteTrustedProvidersCertificates, boolean deleteDestinations) throws SAML2ConfigurationException {
        if (LOCATION.beInfo()) {
            LOCATION.infoT("Triggered deletion of the default SAML2 configuration with options: delete local provider keypairs: {0}; delete certificates of all trusted providers: {1}; delete destinations of all trusted providers: {2}", new Object[]{deleteLocalProviderKeypairs, deleteTrustedProvidersCertificates, deleteDestinations});
        }
        return this.deleteSAML2Configuration(this.defaultSAML2Configuration, null, deleteLocalProviderKeypairs, deleteTrustedProvidersCertificates, deleteDestinations);
    }

    @Override
    public SAML2CfgDeletionReport deleteSAML2Configuration(String name, boolean deleteLocalProviderKeypairs, boolean deleteTrustedProvidersCertificates, boolean deleteDestinations) throws SAML2ConfigurationException {
        SAML2Config config;
        if (LOCATION.beInfo()) {
            LOCATION.infoT("Triggered deletion of the additional SAML2 configuration with name: {0} and options: delete local provider keypairs: {1}; delete certificates of all trusted providers: {2}; delete destinations of all trusted providers: {3}", new Object[]{name, deleteLocalProviderKeypairs, deleteTrustedProvidersCertificates, deleteDestinations});
        }
        if ((config = this.additionalSAML2Configurations.get(name)) == null) {
            throw new SAML2ConfigurationException("SAML2 configuration with name: " + name + " does not exists");
        }
        return this.deleteSAML2Configuration(config, name, deleteLocalProviderKeypairs, deleteTrustedProvidersCertificates, deleteDestinations);
    }

    private SAML2CfgDeletionReport deleteSAML2Configuration(SAML2Config config, String saml2ConfigName, boolean deleteLocalProviderKeypairs, boolean deleteTrustedProvidersCertificates, boolean deleteDestinations) throws SAML2ConfigurationException {
        SAML2LocalProvider localProvider = config.getLocalProvidersConfiguration().getLocalProvider();
        String keystoreView = localProvider.getKeyStoreViewName();
        HashSet<String> usedKeypairs = new HashSet();
        HashSet<String> usedCertificates = new HashSet<String>();
        HashSet<String> usedDestinations = new HashSet<String>();
        if (deleteLocalProviderKeypairs) {
            usedKeypairs = SAML2CfgInternalUtils.getUsedKeypairs(localProvider);
        }
        if (deleteTrustedProvidersCertificates || deleteDestinations) {
            ArrayList<SAML2TrustedProvider> trustedProviders = new ArrayList<SAML2TrustedProvider>();
            trustedProviders.addAll(config.getTrustedIdPsConfiguration().getAllTrustedIdPs());
            trustedProviders.addAll(config.getTrustedSPsConfiguration().getAllTrustedSPs());
            for (SAML2TrustedProvider trustedProvider : trustedProviders) {
                usedCertificates.addAll(SAML2CfgInternalUtils.getUsedCertificates(trustedProvider));
                usedDestinations.addAll(SAML2CfgInternalUtils.getUsedDestinations(trustedProvider));
            }
        }
        if (config.isDefaultSAML2Config()) {
            this.deleteDefaultSAML2Configuration();
        } else {
            this.deleteSAML2Configuration(saml2ConfigName);
        }
        SAML2CfgDeletionReportImpl result = new SAML2CfgDeletionReportImpl();
        if (!CfgUtils.isEmpty(keystoreView)) {
            if (deleteLocalProviderKeypairs) {
                SAML2CfgInternalUtils.deleteKeypairs(keystoreView, usedKeypairs, result);
            }
            if (deleteTrustedProvidersCertificates) {
                SAML2CfgInternalUtils.deleteCertificates(keystoreView, usedCertificates, result);
            }
        } else if (LOCATION.beWarning()) {
            LOCATION.warningT("Could not delete the keypairs of the local provider and the certificates of the trusted providers, because there is not configured keystore view in the default SAML2 configuration");
        }
        if (deleteDestinations) {
            SAML2CfgInternalUtils.deleteDestinations(usedDestinations, result);
        }
        return result;
    }

    public synchronized void deleteAllAdditionalSAML2Configurations() throws SAML2ConfigurationException {
        SAML2CfgSecurityManager.getInstance().checkWritePermission();
        boolean isPartialyDeleted = false;
        Set<String> keys = this.additionalSAML2Configurations.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String saml2ConfigurationName = iterator.next();
            SAML2ConfigImpl saml2Config = (SAML2ConfigImpl)this.additionalSAML2Configurations.get(saml2ConfigurationName);
            if (saml2Config == null) continue;
            try {
                saml2Config.destroy();
                this.deleteCfgObject(saml2Config);
                iterator.remove();
                this.updateableSAML2Configurations.remove(saml2Config.getCfgPath());
                this.saml2ConfigurationNames.remove(saml2Config.getCfgPath());
            }
            catch (CfgStorageException e) {
                LOCATION.traceThrowableT(500, "Could not delete SAML2 configuration with name: " + saml2ConfigurationName, (Throwable)e);
                isPartialyDeleted = true;
            }
        }
        if (isPartialyDeleted) {
            throw new SAML2ConfigurationException("Could not delete some of the SAML2 configurations.");
        }
    }

    @Override
    public synchronized SAML2Config createNewSAML2Configuration(String name) throws SAML2ConfigurationException {
        SAML2CfgSecurityManager.getInstance().checkWritePermission();
        if (name == null || name.length() < 1) {
            throw new SAML2ConfigurationException("Name of the new SAML2 configuration cannot be empty");
        }
        if (this.additionalSAML2Configurations.containsKey(name)) {
            throw new SAML2ConfigurationException("SAML2 configuration with name: " + name + " already exists");
        }
        SAML2ConfigImpl newConfig = new SAML2ConfigImpl(ADDITIONAL_SAML2_CONFIG, name);
        this.addAdditionalSAML2Configuration(name, newConfig.getCfgPath(), newConfig);
        return newConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storageChanged(CfgChangeEvent event) {
        CfgChangeEvent[] detailedEvents = event.getDetailedChangeEvents();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received detailed change events: {0}", new Object[]{Arrays.asList(detailedEvents)});
        }
        CfgChangeEvent lastEvent = detailedEvents[detailedEvents.length - 1];
        String lastEventPath = lastEvent.getPath();
        int action = lastEvent.getAction();
        if (lastEventPath.endsWith("additional_config") && action == 1) {
            String pathToAdditionalConfiguration = CfgUtils.extractRelativePathToFirstSubNode(lastEventPath, ADDITIONAL_SAML2_CONFIG);
            SAML2GlobalConfigImpl sAML2GlobalConfigImpl = this;
            synchronized (sAML2GlobalConfigImpl) {
                if (!this.updateableSAML2Configurations.containsKey(pathToAdditionalConfiguration)) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("New SAML2 additional configuration with path: {0} is created", new Object[]{pathToAdditionalConfiguration});
                    }
                    try {
                        SAML2ConfigImpl saml2Configuration = new SAML2ConfigImpl(pathToAdditionalConfiguration, false);
                        String name = saml2Configuration.getName();
                        this.addAdditionalSAML2Configuration(name, pathToAdditionalConfiguration, saml2Configuration);
                    }
                    catch (SAML2ConfigurationException e) {
                        LOCATION.traceThrowableT(500, "Could not initialize SAML2 configuration with path: " + pathToAdditionalConfiguration, (Throwable)e);
                    }
                }
            }
        }
        if (CfgUtils.isOneSubNode(lastEventPath, ADDITIONAL_SAML2_CONFIG) && action == 2) {
            String pathToAdditionalConfiguration = CfgUtils.extractRelativePathToFirstSubNode(lastEventPath, ADDITIONAL_SAML2_CONFIG);
            SAML2GlobalConfigImpl sAML2GlobalConfigImpl = this;
            synchronized (sAML2GlobalConfigImpl) {
                if (this.updateableSAML2Configurations.containsKey(pathToAdditionalConfiguration)) {
                    String name = this.saml2ConfigurationNames.remove(pathToAdditionalConfiguration);
                    this.additionalSAML2Configurations.remove(name);
                    SAML2ConfigImpl saml2Config = this.updateableSAML2Configurations.remove(pathToAdditionalConfiguration);
                    saml2Config.destroy();
                }
            }
        }
    }

    private synchronized void loadAllAdditionalSAML2Configurations() throws SAML2ConfigurationException {
        String[] additionalSAML2ConfigurationPaths;
        this.additionalSAML2Configurations.clear();
        try {
            additionalSAML2ConfigurationPaths = this.getSubCfgPaths(ADDITIONAL_SAML2_CONFIG);
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not read additional SAML2 configurations", e);
        }
        if (additionalSAML2ConfigurationPaths != null) {
            String[] stringArray = additionalSAML2ConfigurationPaths;
            int n = additionalSAML2ConfigurationPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String additionalSAML2ConfigPath = stringArray[n2];
                if (additionalSAML2ConfigPath != null && additionalSAML2ConfigPath.length() > 0) {
                    SAML2ConfigImpl saml2Config = new SAML2ConfigImpl(additionalSAML2ConfigPath, false);
                    String configName = saml2Config.getName();
                    if (configName != null && configName.length() > 0) {
                        this.addAdditionalSAML2Configuration(configName, additionalSAML2ConfigPath, saml2Config);
                    } else if (LOCATION.beDebug()) {
                        LOCATION.debugT("The additional SAML2 configuration with path: {0} does not have name. It cannot be added to the list of additional SAML2 configurations");
                    }
                }
                ++n2;
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There are not any additional SAML2 configurations");
        }
    }
}

