/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2ModifiableGlobalSettingsImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableCfgObjectBase;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2GlobalSettings;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableGlobalSettings;
import com.sap.security.saml2.cfg.storage.CfgChangeEvent;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.storage.StorageChangedListener;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.tc.logging.Location;

public class SAML2GlobalSettingsImpl
extends SAML2UpdateableCfgObjectBase
implements SAML2GlobalSettings,
StorageChangedListener {
    private static final long serialVersionUID = 1L;
    protected static final String CFG_PATH = "global_settings";
    protected static final String CFG_SHEET_NAME = "global_settings";
    protected static final String KEY_CONTROL_FLAG = "control_flag";
    protected static final String KEY_EXPIRED_ARTIFACTS_CLEAN_TIMEOUT = "expired_artifacts_clean_timeout";
    protected static final String KEY_EXPIRED_ASSERTIONS_CLEAN_TIMEOUT = "expired_assertions_clean_timeout";
    protected static final String KEY_EXPIRED_IDP_SESSIONS_CLEAN_TIMEOUT = "expired_idp_sessions_clean_timeout";
    protected static final String KEY_LOCK_OBTAINING_TIMEOUT = "lock_obtaining_timeout";
    protected static final String KEY_VERSION = "version";
    private static final Location LOCATION = Location.getLocation(SAML2GlobalSettingsImpl.class);

    SAML2GlobalSettingsImpl() {
        super("global_settings", "global_settings");
        try {
            this.registerAsStorageListener(this);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not register storage listener for SAML2 global settings with path: {0}", new Object[]{this.getCfgPath()}, (Throwable)e);
        }
    }

    @Override
    public int getControlFlag() {
        return this.readIntProperty(KEY_CONTROL_FLAG, CfgConstants.DEFAULT_CONTROL_FLAG);
    }

    @Override
    public int getExpiredArtifactsCleanTimeoutInMinutes() {
        return this.readIntProperty(KEY_EXPIRED_ARTIFACTS_CLEAN_TIMEOUT, 5);
    }

    @Override
    public int getExpiredAssertionsCleanTimeoutInMinutes() {
        return this.readIntProperty(KEY_EXPIRED_ASSERTIONS_CLEAN_TIMEOUT, 5);
    }

    @Override
    public int getExpiredIdPSessionsCleanTimeoutInMinutes() {
        return this.readIntProperty(KEY_EXPIRED_IDP_SESSIONS_CLEAN_TIMEOUT, 360);
    }

    @Override
    public int getLockObtainingTimeoutInSeconds() {
        return this.readIntProperty(KEY_LOCK_OBTAINING_TIMEOUT, 30);
    }

    @Override
    public int getVersion() {
        return this.readIntProperty(KEY_VERSION, 0);
    }

    @Override
    public SAML2ModifiableGlobalSettings getModifiableGlobalSettings() throws SAML2ConfigurationException {
        return new SAML2ModifiableGlobalSettingsImpl(this);
    }

    @Override
    public void storageChanged(CfgChangeEvent event) {
        this.update();
    }

    @Override
    protected void cleanCachedObjects() {
    }

    void deleteGlobalSettings() throws SAML2ConfigurationException {
        try {
            this.deleteCfgObject(this);
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not delete global settings.", e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nGlobal settings cfg path: ").append(super.toString());
        builder.append("\nControl flag: ").append(this.getControlFlag());
        builder.append("\nVersion: ").append(this.getVersion());
        builder.append("\nExpired artifacts clean timeout: ").append(this.getExpiredArtifactsCleanTimeoutInMinutes());
        builder.append("\nExpired assertions clean timeout: ").append(this.getExpiredAssertionsCleanTimeoutInMinutes());
        builder.append("\nExpired IdP sessions clean timeout: ").append(this.getExpiredIdPSessionsCleanTimeoutInMinutes());
        builder.append("\nTimeout for lock obtaining: ").append(this.getLockObtainingTimeoutInSeconds());
        builder.append("\n");
        return builder.toString();
    }
}

