/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2LocalIdPImpl;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2IdPAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.write.SAML2IdPAuthenticationContextSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public class SAML2IdPAuthenticationContextImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2IdPAuthenticationContext,
SAML2IdPAuthenticationContextSetter {
    private static final String TOSTRING_PATTERN = "SAML2 authentication context: {0}\nLogin module name: {1}\nCfg path: {2}";
    private static final Location LOCATION = Location.getLocation(SAML2IdPAuthenticationContextImpl.class);
    private static final String KEY_AUTHN_CONTEXT = "authn_context";
    private static final String KEY_LOGIN_MODULE = "login_module";
    SAML2LocalIdPImpl parent;
    private String authnContextName;
    private String loginModuleName;

    public SAML2IdPAuthenticationContextImpl() {
    }

    public SAML2IdPAuthenticationContextImpl(SAML2LocalIdPImpl parent, String subPath, String propertySheet) {
        super(parent, subPath, propertySheet);
        this.parent = parent;
    }

    @Override
    public String getLoginModuleName() {
        return this.loginModuleName;
    }

    @Override
    public String getSAML2AuthenticationContextName() {
        return this.authnContextName;
    }

    @Override
    public SAML2CfgAuthenticationContext getSAML2CfgAuthenticationContext() {
        if (this.authnContextName == null || this.authnContextName.length() < 0) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Could not obtain the authentication context configuration by empty authentication context name stored in this mapping : {0}", new Object[]{this});
            }
            return null;
        }
        SAML2CfgAuthenticationContext authContext = this.parent.getAuthenticationContextByName(this.authnContextName);
        if (authContext == null && LOCATION.beWarning()) {
            LOCATION.warningT("There is not configuration for authentication context with name: {0}", new Object[]{this.authnContextName});
        }
        return authContext;
    }

    @Override
    public void setLoginModuleName(String name) {
        this.loginModuleName = name;
    }

    @Override
    public void setSAML2AuthenticationContext(String authnContext) {
        this.authnContextName = authnContext;
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        String dbAuthnContextName;
        this.authnContextName = dbAuthnContextName = this.readProperty(KEY_AUTHN_CONTEXT);
        this.loginModuleName = this.readProperty(KEY_LOGIN_MODULE);
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        this.setProperty(KEY_AUTHN_CONTEXT, this.authnContextName);
        this.setProperty(KEY_LOGIN_MODULE, this.loginModuleName);
        super.writeConfiguration();
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.authnContextName, this.loginModuleName, super.toString());
    }
}

