/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.exceptions.KeystoreViewEntryNotFoundException;
import com.sap.security.saml2.cfg.exceptions.KeystoreViewNotFoundException;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.util.SAML2CfgServicesManager;
import com.sap.security.saml2.lib.common.exceptions.SAML2ServiceInstantiationException;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class SAML2KeystoreWrapper {
    private static final Location LOCATION = Location.getLocation(SAML2KeystoreWrapper.class);
    private static final SAML2KeystoreWrapper INSTANCE = new SAML2KeystoreWrapper();

    public static SAML2KeystoreWrapper getInstance() throws SAML2ConfigurationException {
        return INSTANCE;
    }

    private SAML2KeystoreWrapper() {
    }

    public synchronized String importCertificate(String viewName, String providerName, String suffix, String certificateBase64) throws SAML2ConfigurationException {
        String entryName = suffix != null && suffix.length() > 0 ? String.valueOf(providerName) + "_" + suffix : providerName;
        certificateBase64 = this.prepareCertificateBase64(certificateBase64);
        try {
            KeyStore keystore = this.getViewKeystore(viewName);
            String tempName = entryName;
            int index = 1;
            while (keystore.containsAlias(tempName)) {
                tempName = String.valueOf(entryName) + "_" + index;
                ++index;
            }
            entryName = tempName;
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate cert = factory.generateCertificate(new ByteArrayInputStream(certificateBase64.getBytes("UTF-8")));
            keystore.setCertificateEntry(entryName, cert);
            SAML2CfgServicesManager.getInstance().getCfgKeystoreServiceInstance().storeKeystore(keystore, viewName);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Imported certificate " + entryName + ":" + certificateBase64);
            }
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not import certificate as entry with name: " + entryName + " in view: " + viewName, e);
        }
        return entryName;
    }

    public synchronized void importCertificate(String viewName, String entryName, String certificateBase64) throws SAML2ConfigurationException {
        certificateBase64 = this.prepareCertificateBase64(certificateBase64);
        try {
            KeyStore keystore = this.getViewKeystore(viewName);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate cert = factory.generateCertificate(new ByteArrayInputStream(certificateBase64.getBytes("UTF-8")));
            keystore.setCertificateEntry(entryName, cert);
            SAML2CfgServicesManager.getInstance().getCfgKeystoreServiceInstance().storeKeystore(keystore, viewName);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Imported certificate " + entryName + ":" + certificateBase64);
            }
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not import certificate as entry with name: " + entryName + " in view: " + viewName, e);
        }
    }

    public String getCertificateExtendedInfo(String certificateBase64) throws Exception {
        if (SAML2KeystoreWrapper.isEmpty(certificateBase64)) {
            return "";
        }
        certificateBase64 = this.prepareCertificateBase64(certificateBase64);
        return SAML2CfgServicesManager.getInstance().getCfgKeystoreServiceInstance().getCertificateExtendedInfo(certificateBase64);
    }

    public static String[] getCommonNameRDNs(X509Certificate cert) throws Exception {
        return SAML2CfgServicesManager.getInstance().getCfgKeystoreServiceInstance().getCommonNameRDNs(cert);
    }

    public synchronized KeyStore getViewKeystore(String viewName) throws SAML2ConfigurationException, KeystoreViewNotFoundException {
        try {
            if (!SAML2CfgServicesManager.getInstance().getCfgKeystoreServiceInstance().keystoreExists(viewName)) {
                LOCATION.debugT("View " + viewName + " does not exist.");
                throw new KeystoreViewNotFoundException("View " + viewName + " does not exist");
            }
            return SAML2CfgServicesManager.getInstance().getCfgKeystoreServiceInstance().getKeystore(viewName);
        }
        catch (SAML2ServiceInstantiationException e) {
            throw new SAML2ConfigurationException("Could not obtain keystore with name: " + viewName, e);
        }
    }

    boolean existKeystoreView(final String viewName) throws SAML2ConfigurationException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return SAML2CfgServicesManager.getInstance().getCfgKeystoreServiceInstance().keystoreExists(viewName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception exception = e.getException();
            if (exception != null) {
                if (exception instanceof SAML2ConfigurationException) {
                    throw (SAML2ConfigurationException)exception;
                }
                throw new SAML2ConfigurationException("Could not check existence of view " + viewName, exception);
            }
            LOCATION.traceThrowableT(400, "Could not check existence of view " + viewName, (Throwable)e);
            return false;
        }
    }

    void createView(String keystoreName) throws SAML2ConfigurationException {
        try {
            SAML2CfgServicesManager.getInstance().getCfgKeystoreServiceInstance().createKeystore(keystoreName);
        }
        catch (SAML2ServiceInstantiationException e) {
            throw new SAML2ConfigurationException("Keystore with name: " + keystoreName + "could not be created", e);
        }
    }

    void grantKeystorePermissions(String keystoreName) throws SAML2ConfigurationException {
        try {
            SAML2CfgServicesManager.getInstance().getCfgKeystoreServiceInstance().grantKeystorePermissions(keystoreName);
        }
        catch (SAML2ServiceInstantiationException e) {
            LOCATION.traceThrowableT(500, "Could not grant keystore permissions over view: {0}", new Object[]{keystoreName}, (Throwable)e);
            throw new SAML2ConfigurationException("Could not grant keystore permissions over view: " + keystoreName, e);
        }
    }

    Certificate getCertificate(final String viewName, final String entryName) throws Exception {
        if (SAML2KeystoreWrapper.isEmpty(viewName)) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Could not obtain certificate with name: [{0}] from keystore view given with empty name: [{1}]", new Object[]{entryName, viewName});
            }
            return null;
        }
        if (SAML2KeystoreWrapper.isEmpty(entryName)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Could not obtain certificate given with empty name: [{0}] from keystore view: [{1}]", new Object[]{entryName, viewName});
            }
            return null;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Certificate>(){

                @Override
                public Certificate run() throws Exception {
                    Certificate[] certificateChain;
                    KeyStore keystore = SAML2KeystoreWrapper.this.getViewKeystore(viewName);
                    Certificate result = keystore.getCertificate(entryName);
                    if (result == null && (certificateChain = keystore.getCertificateChain(entryName)) != null && certificateChain.length > 0) {
                        result = certificateChain[0];
                    }
                    if (result == null && LOCATION.beWarning()) {
                        LOCATION.warningT("Could not obtain certificate with name: [{0}] from keystore view: [{1}]", new Object[]{entryName, viewName});
                    }
                    return result;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception exception = e.getException();
            if (exception != null) {
                throw exception;
            }
            LOCATION.traceThrowableT(400, "Could not obtain certificate with name: " + entryName + " from keystore view: " + viewName, (Throwable)e);
            return null;
        }
    }

    PrivateKey getPrivateKey(String viewName, String entryName) throws Exception {
        if (SAML2KeystoreWrapper.isEmpty(viewName)) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Could not obtain private key with name: [{0}] from keystore view given with empty name: [{1}]", new Object[]{entryName, viewName});
            }
            return null;
        }
        if (SAML2KeystoreWrapper.isEmpty(entryName)) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Could not obtain private key given with empty name: [{0}] from keystore view: [{1}]", new Object[]{entryName, viewName});
            }
            return null;
        }
        KeyStore keystore = this.getViewKeystore(viewName);
        Key key = SAML2CfgServicesManager.getInstance().getCfgKeystoreServiceInstance().readKeyEntry(keystore, entryName);
        if (key != null) {
            return (PrivateKey)key;
        }
        LOCATION.debugT(String.valueOf(entryName) + " does not exist in view " + viewName);
        throw new KeystoreViewEntryNotFoundException(String.valueOf(entryName) + " does not exist in view " + viewName);
    }

    synchronized void deleteKeystoreEntry(String viewName, String entryName) throws SAML2ConfigurationException, KeystoreViewNotFoundException, KeyStoreException {
        if (SAML2KeystoreWrapper.isEmpty(viewName)) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Could not delete keystore entry: [{0}] from empty keystore view: [{1}]", new Object[]{entryName, viewName});
            }
            return;
        }
        if (SAML2KeystoreWrapper.isEmpty(entryName)) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Could not delete keystore entry with empty name: [{0}] from empty keystore view: [{1}]", new Object[]{entryName, viewName});
            }
            return;
        }
        KeyStore keystore = this.getViewKeystore(viewName);
        keystore.deleteEntry(entryName);
        SAML2CfgServicesManager.getInstance().getCfgKeystoreServiceInstance().storeKeystore(keystore, viewName);
    }

    private String prepareCertificateBase64(String certificateBase64) {
        String result = "-----BEGIN CERTIFICATE-----\n" + certificateBase64 + "\n-----END CERTIFICATE-----";
        return result;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() < 1;
    }
}

