/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2AffiliationImpl;
import com.sap.security.saml2.cfg.SAML2IdPAuthenticationContextImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableLocalIdPImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableProviderBase;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2BindingDirection;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Affiliation;
import com.sap.security.saml2.cfg.interfaces.read.SAML2BackChannelSecurityPolicy;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.SAML2IdPAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2MetadataSettings;
import com.sap.security.saml2.cfg.interfaces.read.SAML2RedirectApplicationConfiguration;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableLocalIdP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableLocalProvider;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.tc.logging.Location;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SAML2LocalIdPImpl
extends SAML2UpdateableProviderBase
implements SAML2LocalIdP {
    private static final Location LOCATION = Location.getLocation(SAML2LocalIdPImpl.class);
    private SAML2LocalProvider localProvider;
    private Map<String, SAML2Affiliation> affiliationsMap;
    private Map<String, SAML2IdPAuthenticationContext> authnContextsMap;
    protected static final String CFG_SHEET_NAME = "idp";
    protected static final String CFG_SUB_PATH_AFFILIATIONS = "affiliations";
    protected static final String CFG_SUB_PATH_AUTHN_CONTEXT_MAPPINGS = "authn_context_mappings";
    protected static final String KEY_ASSERTION_VALIDITY_NOT_BEFORE = "assertion_validity_not_before";
    protected static final String KEY_ASSERTION_VALIDITY_NOT_AFTER = "assertion_validity_not_after";
    protected static final String KEY_PROXY_RESTRICTION = "proxy_restriction";
    protected static final String KEY_IS_PROXYING_ENFORCED = "is_proxying_enforced";
    protected static final String KEY_CDC_DOMAIN = "cdc_domain";
    protected static final String KEY_CDC_RELAXATION_LEVEL = "cdc_relaxation_level";
    protected static final String KEY_CDC_MAX_AGE = "cdc_max_age";
    protected static final String KEY_USE_INTERNAL_IDP_DISCOVERY_WRITE_SERVICE = "use_internal_cdc_write_service";
    protected static final String KEY_USE_EXTERNAL_IDP_DISCOVERY_WRITE_SERVICE = "use_external_cdc_write_service";
    protected static final String KEY_EXTERNAL_IDP_DISCOVERY_WRITE_SERVICE_URL = "external_cdc_write_service_url";
    protected static final String KEY_GLOBAL_SESSION_LIFETIME = "global_session_lifetime";
    protected static final String KEY_SINGLE_SIGN_ON_SUPPORTED_BINDINGS = "supported_bindings_sso";
    protected static final String KEY_SINGLE_LOGOUT_SUPPORTED_BINDINGS = "supported_bindings_slo";
    protected static final String KEY_MANAGE_NAME_ID_SUPPORTED_BINDINGS = "supported_bindings_mni";
    protected static final String KEY_DEFAULT_SINGLE_LOGOUT_BINDING = "default_slo_binding";
    protected static final String KEY_IDP_INITIATED_SINGLE_LOGOUT_DIRECTION = "idp_initiated_slo_direction";
    protected static final String KEY_MULTIPLE_GLOBAL_SESSIONS_ALLOWED = "multiple_global_sessions_allowed";
    protected static final String KEY_IDP_MIXED_MODE_ENABLED = "idp_mixed_mode_enabled";
    protected static final String KEY_DEFAULT_AUTHN_CONTEXTS_HTTP = "default_authn_contexts_http";
    protected static final String KEY_DEFAULT_AUTHN_CONTEXTS_HTTPS = "default_authn_contexts_https";
    protected static final String KEY_IDP_INITIATED_SSO_ENABLED = "idp_initiated_sso_enabled";
    protected static final String KEY_SP_INITIATED_SSO_ENABLED = "sp_initiated_sso_enabled";
    protected static final String KEY_IDP_INITIATED_SLO_ENABLED = "idp_initiated_slo_enabled";
    protected static final String KEY_SP_INITIATED_SLO_ENABLED = "sp_initiated_slo_enabled";
    protected static final String KEY_IDP_INITIATED_MNI_ENABLED = "idp_initiated_mni_enabled";
    protected static final String KEY_SP_INITIATED_MNI_ENABLED = "sp_initiated_mni_enabled";
    protected static final String KEY_DISPLAY_SAML2_ERROR_PAGE_ENABLED = "display_saml2_error_page_enabled";
    protected static final String KEY_ADD_SESSION_NOT_ON_OR_AFTER = "add_session_not_on_or_after";

    SAML2LocalIdPImpl(String cfgRootPath, SAML2LocalProvider localProvider) {
        super(cfgRootPath, CFG_SHEET_NAME);
        this.localProvider = localProvider;
    }

    @Override
    public SAML2Affiliation getAffiliation(String affiliationName) {
        return this.readAffiliation(affiliationName);
    }

    @Override
    public Collection<SAML2Affiliation> getAffiliations() {
        return this.readAffiliations();
    }

    @Override
    public int getAssertionValidityNotAfterInMinutes() {
        return this.readIntProperty(KEY_ASSERTION_VALIDITY_NOT_AFTER, 10);
    }

    @Override
    public int getAssertionValidityNotBeforeInMinutes() {
        return this.readIntProperty(KEY_ASSERTION_VALIDITY_NOT_BEFORE, 5);
    }

    @Override
    public Integer getProxyRestriction() {
        return this.readIntProperty(KEY_PROXY_RESTRICTION, 1);
    }

    @Override
    public boolean isProxyingEnforced() {
        return Boolean.parseBoolean(this.readProperty(KEY_IS_PROXYING_ENFORCED));
    }

    @Override
    public boolean isToUseInternalIdPDiscoveryWriteService() {
        return Boolean.parseBoolean(this.readProperty(KEY_USE_INTERNAL_IDP_DISCOVERY_WRITE_SERVICE));
    }

    @Override
    public boolean isToUseExternalIdPDiscoveryWriteService() {
        return Boolean.parseBoolean(this.readProperty(KEY_USE_EXTERNAL_IDP_DISCOVERY_WRITE_SERVICE));
    }

    @Override
    public String getExternalIdPDiscoveryWriteServiceUrl() {
        return this.readProperty(KEY_EXTERNAL_IDP_DISCOVERY_WRITE_SERVICE_URL);
    }

    @Override
    public String getCDCDomain() {
        return this.readProperty(KEY_CDC_DOMAIN);
    }

    @Override
    public int getCDCDomainRelaxationLevel() {
        return this.readIntProperty(KEY_CDC_RELAXATION_LEVEL, 1);
    }

    @Override
    public int getCDCMaxAge() {
        return this.readIntProperty(KEY_CDC_MAX_AGE, -1);
    }

    @Override
    public List<SAML2IdPAuthenticationContext> getDefaultIdPAuthnContextsHTTP() {
        return this.readDefaultAuthnContextsList(KEY_DEFAULT_AUTHN_CONTEXTS_HTTP);
    }

    @Override
    public List<SAML2IdPAuthenticationContext> getDefaultIdPAuthnContextsHTTPS() {
        return this.readDefaultAuthnContextsList(KEY_DEFAULT_AUTHN_CONTEXTS_HTTPS);
    }

    @Override
    public int getGlobalSessionLifetimeInSeconds() {
        return this.readIntProperty(KEY_GLOBAL_SESSION_LIFETIME, 3600);
    }

    @Override
    public SAML2IdPAuthenticationContext getIdPAuthnContextByName(String authnContextName) {
        if (authnContextName == null || authnContextName.length() < 1) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Could not obtain the IdP authentication context mapping by empty authentication context name");
            }
            return null;
        }
        return this.readIdPAuthnContext(authnContextName);
    }

    @Override
    public SAML2IdPAuthenticationContext getIdPAuthnContextByAlias(String authnContextAlias) {
        if (authnContextAlias == null || authnContextAlias.length() < 1) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Could not obtain the IdP authentication context mapping by empty authentication context alias");
            }
            return null;
        }
        SAML2CfgAuthenticationContext authnContext = this.getAuthenticationContextByAlias(authnContextAlias);
        if (authnContext == null) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("There is not authentication context configuration for alias: {0}", new Object[]{authnContextAlias});
            }
            return null;
        }
        String authnContextName = authnContext.getName();
        if (authnContextName == null && LOCATION.beWarning()) {
            LOCATION.warningT("The authentication context: {0} does not have a name", new Object[]{authnContext});
        }
        return this.readIdPAuthnContext(authnContextName);
    }

    @Override
    public Collection<SAML2IdPAuthenticationContext> getIdPAuthnContexts() {
        return this.readIdPAuthnContexts();
    }

    @Override
    public Set<String> getSupportedIdPAuthnContextNames() {
        return this.readIdPAuthnContextNames();
    }

    @Override
    public String getSingleLogoutLocationHardCoded() {
        return "/saml2/idp/slo";
    }

    @Override
    public String getManageNameIDLocationHardCoded() {
        return "/saml2/idp/mni";
    }

    @Override
    public Set<SAML2Binding> getSingleLogoutSupportedBindings() {
        return this.readSupportedBindings(KEY_SINGLE_LOGOUT_SUPPORTED_BINDINGS);
    }

    @Override
    public Set<SAML2Binding> getManageNameIDSupportedBindings() {
        return this.readSupportedBindings(KEY_MANAGE_NAME_ID_SUPPORTED_BINDINGS);
    }

    @Override
    public String getSingleSignOnLocationHardCoded() {
        return "/saml2/idp/sso";
    }

    @Override
    public Set<SAML2Binding> getSingleSignOnSupportedBindings() {
        return this.readSupportedBindings(KEY_SINGLE_SIGN_ON_SUPPORTED_BINDINGS);
    }

    @Override
    public boolean isMultipleGlobalSessionsAllowed() {
        return Boolean.parseBoolean(this.readProperty(KEY_MULTIPLE_GLOBAL_SESSIONS_ALLOWED, "true"));
    }

    @Override
    public String getArtifactResolutionLocationHardCoded() {
        return this.localProvider.getArtifactResolutionLocationHardCoded();
    }

    @Override
    public Set<SAML2Binding> getArtifactResolutionSupportedBindings() {
        return this.localProvider.getArtifactResolutionSupportedBindings();
    }

    @Override
    public int getArtifactValidityPeriodInSeconds() {
        return this.localProvider.getArtifactValidityPeriodInSeconds();
    }

    @Override
    public Certificate getCertificateForSignature() throws SAML2ConfigurationException {
        return this.localProvider.getCertificateForSignature();
    }

    @Override
    public Certificate getCertificateForEncryption() throws SAML2ConfigurationException {
        return this.localProvider.getCertificateForEncryption();
    }

    @Override
    public int getClockSkewToleranceInSeconds() {
        return this.localProvider.getClockSkewToleranceInSeconds();
    }

    @Override
    public String getEncryptionKeyPairName() {
        return this.localProvider.getEncryptionKeyPairName();
    }

    @Override
    public String getKeyStoreViewName() {
        return this.localProvider.getKeyStoreViewName();
    }

    @Override
    public String getTrustedCAsViewName() {
        return this.localProvider.getTrustedCAsViewName();
    }

    @Override
    public SAML2ModifiableLocalProvider getModifiableLocalProvider() throws SAML2ConfigurationException {
        return this.localProvider.getModifiableLocalProvider();
    }

    @Override
    public String getName() {
        return this.localProvider.getName();
    }

    @Override
    public byte[] getID() {
        return this.localProvider.getID();
    }

    @Override
    public PrivateKey getPrivateKeyForEncryption() throws SAML2ConfigurationException {
        return this.localProvider.getPrivateKeyForEncryption();
    }

    @Override
    public PrivateKey getPrivateKeyForSignature() throws SAML2ConfigurationException {
        return this.localProvider.getPrivateKeyForSignature();
    }

    @Override
    public PublicKey getPublicKeyForEncryption() throws SAML2ConfigurationException {
        return this.localProvider.getPublicKeyForEncryption();
    }

    @Override
    public String getSigningKeyPairName() {
        return this.localProvider.getSigningKeyPairName();
    }

    @Override
    public boolean isToIncludeCertInSignature() {
        return this.localProvider.isToIncludeCertInSignature();
    }

    @Override
    public boolean isToSignMetadata() {
        return this.localProvider.isToSignMetadata();
    }

    @Override
    public SAML2BindingDirection getIdPInitiatedSingleLogoutDirection() {
        String dbDirection = this.readProperty(KEY_IDP_INITIATED_SINGLE_LOGOUT_DIRECTION);
        return SAML2BindingDirection.valueOf(dbDirection, CfgConstants.DEFAULT_IDP_INITIATED_SLO_DIRECTION);
    }

    @Override
    public boolean issueSAPLogonTickets() {
        return this.localProvider.issueSAPLogonTickets();
    }

    @Override
    public synchronized SAML2BackChannelSecurityPolicy getBackChannelSecurityPolicy() {
        return this.localProvider.getBackChannelSecurityPolicy();
    }

    @Override
    public synchronized SAML2MetadataSettings getMetadataSettings() {
        return this.localProvider.getMetadataSettings();
    }

    @Override
    public Collection<SAML2CfgAuthenticationContext> getAuthenticationContexts() {
        return this.localProvider.getAuthenticationContexts();
    }

    @Override
    public SAML2CfgAuthenticationContext getAuthenticationContextByName(String name) {
        return this.localProvider.getAuthenticationContextByName(name);
    }

    @Override
    public SAML2CfgAuthenticationContext getAuthenticationContextByAlias(String alias) {
        return this.localProvider.getAuthenticationContextByAlias(alias);
    }

    @Override
    public Collection<SAML2CfgUMEAttribute> getUMEAttributes() {
        return this.localProvider.getUMEAttributes();
    }

    @Override
    public SAML2CfgUMEAttribute getUMEAttributeByAlias(String alias) {
        return this.localProvider.getUMEAttributeByAlias(alias);
    }

    @Override
    public boolean isPlainHTTPConnectionsEnabled() {
        return this.localProvider.isPlainHTTPConnectionsEnabled();
    }

    @Override
    public String getCustomLogonPageAlias() {
        return this.localProvider.getCustomLogonPageAlias();
    }

    @Override
    public int getIssueInstantValidityNotBeforeInMinutes() {
        return this.localProvider.getIssueInstantValidityNotBeforeInMinutes();
    }

    @Override
    public int getIssueInstantValidityNotAfterInMinutes() {
        return this.localProvider.getIssueInstantValidityNotAfterInMinutes();
    }

    @Override
    public SAML2ModifiableLocalIdP getModifiableLocalIdP() throws SAML2ConfigurationException {
        return new SAML2ModifiableLocalIdPImpl(this);
    }

    private synchronized Collection<SAML2IdPAuthenticationContext> readIdPAuthnContexts() {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.authnContextsMap != null) {
            return this.authnContextsMap.values();
        }
        this.authnContextsMap = new HashMap<String, SAML2IdPAuthenticationContext>();
        String[] authnContextSheets = null;
        try {
            authnContextSheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_AUTHN_CONTEXT_MAPPINGS);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load IdP authentication context mapping configuration", (Throwable)e);
        }
        if (authnContextSheets != null) {
            String[] stringArray = authnContextSheets;
            int n = authnContextSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String authnContextSheet = stringArray[n2];
                SAML2IdPAuthenticationContextImpl authnContext = new SAML2IdPAuthenticationContextImpl(this, CFG_SUB_PATH_AUTHN_CONTEXT_MAPPINGS, authnContextSheet);
                String saml2AuthnContextName = authnContext.getSAML2AuthenticationContextName();
                if (saml2AuthnContextName != null) {
                    this.authnContextsMap.put(saml2AuthnContextName, authnContext);
                }
                ++n2;
            }
        }
        return this.authnContextsMap.values();
    }

    private synchronized Set<String> readIdPAuthnContextNames() {
        if (this.authnContextsMap == null) {
            this.readIdPAuthnContexts();
        }
        return this.authnContextsMap.keySet();
    }

    private synchronized SAML2IdPAuthenticationContext readIdPAuthnContext(String name) {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.authnContextsMap == null) {
            this.readIdPAuthnContexts();
        }
        SAML2IdPAuthenticationContext result = this.authnContextsMap.get(name);
        if (LOCATION.beDebug() && result == null) {
            LOCATION.debugT("There is not IdP authentication context mapping with SAML2 authentication context name: {0}", new Object[]{name});
        }
        return result;
    }

    private synchronized List<SAML2IdPAuthenticationContext> readDefaultAuthnContextsList(String key) {
        ArrayList<SAML2IdPAuthenticationContext> result;
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.getCache().containsKey(key)) {
            result = (ArrayList<SAML2IdPAuthenticationContext>)this.getCache().get(key);
        } else {
            String[] saml2AuthnContextNames = this.getPropertyValue(key, null).getValues();
            result = new ArrayList<SAML2IdPAuthenticationContext>();
            if (saml2AuthnContextNames != null) {
                String[] stringArray = saml2AuthnContextNames;
                int n = saml2AuthnContextNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String saml2AuthnContextName = stringArray[n2];
                    SAML2IdPAuthenticationContext idpAuthnContext = this.readIdPAuthnContext(saml2AuthnContextName);
                    if (idpAuthnContext != null) {
                        result.add(idpAuthnContext);
                    }
                    ++n2;
                }
            }
            this.getCache().put(key, result);
        }
        return result;
    }

    private synchronized Collection<SAML2Affiliation> readAffiliations() {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.affiliationsMap != null) {
            return this.affiliationsMap.values();
        }
        this.affiliationsMap = new HashMap<String, SAML2Affiliation>();
        String[] affiliationSheets = null;
        try {
            affiliationSheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_AFFILIATIONS);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load affiliation configuration", (Throwable)e);
        }
        if (affiliationSheets != null) {
            String[] stringArray = affiliationSheets;
            int n = affiliationSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String affiliationSheet = stringArray[n2];
                SAML2AffiliationImpl affiliation = new SAML2AffiliationImpl(this, CFG_SUB_PATH_AFFILIATIONS, affiliationSheet);
                this.affiliationsMap.put(affiliation.getName(), affiliation);
                ++n2;
            }
        }
        return this.affiliationsMap.values();
    }

    private synchronized SAML2Affiliation readAffiliation(String name) {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.affiliationsMap == null) {
            this.readAffiliations();
        }
        SAML2Affiliation affiliation = this.affiliationsMap.get(name);
        if (LOCATION.beDebug() && affiliation == null) {
            LOCATION.debugT("There is not affiliation with name: {0}", new Object[]{name});
        }
        return affiliation;
    }

    @Override
    protected synchronized void cleanCachedObjects() {
        this.affiliationsMap = null;
        this.authnContextsMap = null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nIdP cfg path: ").append(super.toString());
        builder.append("\n").append(this.localProvider);
        builder.append("\nAssertion validity not before: ").append(this.getAssertionValidityNotBeforeInMinutes());
        builder.append("\nAssertion validity not after: ").append(this.getAssertionValidityNotAfterInMinutes());
        builder.append("\nSupported contexts: ").append(this.getSupportedIdPAuthnContextNames());
        builder.append("\nDefault contexts HTTP: ").append(this.getDefaultIdPAuthnContextsHTTP());
        builder.append("\nDefault contexts HTTPS: ").append(this.getDefaultIdPAuthnContextsHTTPS());
        builder.append("\nGlobal session lifetime: ").append(this.getGlobalSessionLifetimeInSeconds());
        builder.append("\nUse internal IdP discovery write service: ").append(this.isToUseInternalIdPDiscoveryWriteService());
        builder.append("\nUse external IdP discovery write service: ").append(this.isToUseExternalIdPDiscoveryWriteService());
        builder.append("\nExternal IdP discovery write service url: ").append(this.getExternalIdPDiscoveryWriteServiceUrl());
        builder.append("\nCDC max age: ").append(this.getCDCMaxAge());
        builder.append("\nCDC domain relax level: ").append(this.getCDCDomainRelaxationLevel());
        builder.append("\nCDC domain: ").append(this.getCDCDomain());
        builder.append("\nIs proxying enforced: ").append(this.isProxyingEnforced());
        builder.append("\nProxy Restriction: ").append(this.getProxyRestriction());
        builder.append("\nSSO supported bindings: ").append(this.getSingleSignOnSupportedBindings());
        builder.append("\nSLO supported bindings: ").append(this.getSingleLogoutSupportedBindings());
        builder.append("\nMNI supported bindings: ").append(this.getManageNameIDSupportedBindings());
        builder.append("\nIdP initiated SLO direction: ").append((Object)this.getIdPInitiatedSingleLogoutDirection());
        builder.append("\nIdP-Initiated SSO enabled: ").append(this.isIdPInitiatedSSOEnabled());
        builder.append("\nIdP-Initiated SLO enabled: ").append(this.isIdPInitiatedSLOEnabled());
        builder.append("\nIdP-Initiated MNI enabled: ").append(this.isIdPInitiatedMNIEnabled());
        builder.append("\nSP-Initiated SSO enabled: ").append(this.isSPInitiatedSSOEnabled());
        builder.append("\nSP-Initiated SLO enabled: ").append(this.isSPInitiatedSLOEnabled());
        builder.append("\nSP-Initiated MNI enabled: ").append(this.isSPInitiatedMNIEnabled());
        builder.append("\nDisplay SAML2 error page enabled: ").append(this.isDisplaySAML2ErrorPageEnabled());
        builder.append("\nAdd SessionNotOnOrAfter: ").append(this.isToAddSessionNotOnOrAfter());
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public boolean isIdPInitiatedSLOEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_IDP_INITIATED_SLO_ENABLED, "true"));
    }

    @Override
    public boolean isIdPInitiatedSSOEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_IDP_INITIATED_SSO_ENABLED, "true"));
    }

    @Override
    public boolean isSPInitiatedSLOEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_SP_INITIATED_SLO_ENABLED, "true"));
    }

    @Override
    public boolean isSPInitiatedSSOEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_SP_INITIATED_SSO_ENABLED, "true"));
    }

    @Override
    public boolean isIdPInitiatedMNIEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_IDP_INITIATED_MNI_ENABLED));
    }

    @Override
    public boolean isSPInitiatedMNIEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_SP_INITIATED_MNI_ENABLED));
    }

    @Override
    public boolean isDisplaySAML2ErrorPageEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_DISPLAY_SAML2_ERROR_PAGE_ENABLED, "true"));
    }

    @Override
    public boolean isToAddSessionNotOnOrAfter() {
        return Boolean.parseBoolean(this.readProperty(KEY_ADD_SESSION_NOT_ON_OR_AFTER));
    }

    @Override
    public SAML2RedirectApplicationConfiguration getRedirectApplicationConfiguration() {
        return this.localProvider.getRedirectApplicationConfiguration();
    }
}

