/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2BackChannelSecurityPolicyImpl;
import com.sap.security.saml2.cfg.SAML2CfgAuthenticationContextImpl;
import com.sap.security.saml2.cfg.SAML2CfgUMEAttributeImpl;
import com.sap.security.saml2.cfg.SAML2KeystoreWrapper;
import com.sap.security.saml2.cfg.SAML2MetadataSettingsImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableLocalProviderImpl;
import com.sap.security.saml2.cfg.SAML2RedirectApplicationConfigurationImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableProviderBase;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2BackChannelSecurityPolicy;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2MetadataSettings;
import com.sap.security.saml2.cfg.interfaces.read.SAML2RedirectApplicationConfiguration;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableLocalProvider;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.tc.logging.Location;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SAML2LocalProviderImpl
extends SAML2UpdateableProviderBase
implements SAML2LocalProvider {
    private static final long serialVersionUID = 1L;
    private static final Location LOCATION = Location.getLocation(SAML2LocalProviderImpl.class);
    protected static final String CFG_SHEET_NAME = "common";
    protected static final String CFG_SUB_PATH_AUTHENTICATION_CONTEXTS = "authentication_contexts";
    protected static final String CFG_SUB_PATH_UME_ATTRIBUTES = "ume_attributes";
    protected static final String KEY_ARTIFACT_VALIDITY = "artifact_validity";
    protected static final String KEY_CLOCK_SKEW_TOLERANCE = "clock_skew_tolerance";
    protected static final String KEY_KEYSTORE_VIEW = "keystore_view";
    protected static final String KEY_TRUSTED_CA_VIEW = "trusted_ca_view";
    protected static final String KEY_SIGNING_KEYPAIR = "signing_keypair";
    protected static final String KEY_SECONDARY_SIGNING_KEYPAIR = "secondary_signing_keypair";
    protected static final String KEY_ENCRYPTION_KEYPAIR = "encryption_keypair";
    protected static final String KEY_INCLUDE_CERT_IN_SIGNATURE = "include_cert_in_signature";
    protected static final String KEY_USE_SECONDARY_KEYS_FOR_METADATA = "use_secondary_keys_for_metadata";
    protected static final String KEY_SIGN_METADATA = "sign_metadata";
    protected static final String KEY_ISSUE_SAP_LOGON_TICKETS = "issue_sap_logon_tickets";
    protected static final String KEY_ARTIFACT_RESOLUTION_SUPPORTED_BINDINGS = "supported_bindings_ars";
    protected static final String KEY_PLAIN_HTTP_ENABLED = "plain_http_enabled";
    protected static final String KEY_CUSTOM_LOGON_PAGE_ALIAS = "custom_logon_page_alias";
    protected static final String KEY_ISSUE_INSTANT_VALIDITY_NOT_BEFORE = "issue_instant_not_before";
    protected static final String KEY_ISSUE_INSTANT_VALIDITY_NOT_AFTER = "issue_instant_not_after";
    private SAML2BackChannelSecurityPolicyImpl backChannelSecurity;
    private SAML2MetadataSettingsImpl metadataSettings;
    private Map<String, SAML2CfgAuthenticationContext> authneticationContextsByName;
    private Map<String, SAML2CfgAuthenticationContext> authneticationContextsByAlias;
    private Map<String, SAML2CfgUMEAttribute> umeAttributesByAlias;
    private SAML2RedirectApplicationConfigurationImpl redirectApplicationConfiguration;

    SAML2LocalProviderImpl(String cfgRootPath) {
        super(cfgRootPath, CFG_SHEET_NAME);
    }

    @Override
    public String getArtifactResolutionLocationHardCoded() {
        return "/saml2/ars";
    }

    @Override
    public Set<SAML2Binding> getArtifactResolutionSupportedBindings() {
        return this.readSupportedBindings(KEY_ARTIFACT_RESOLUTION_SUPPORTED_BINDINGS);
    }

    @Override
    public int getArtifactValidityPeriodInSeconds() {
        return this.readIntProperty(KEY_ARTIFACT_VALIDITY, 60);
    }

    @Override
    public int getClockSkewToleranceInSeconds() {
        return this.readIntProperty(KEY_CLOCK_SKEW_TOLERANCE, 120);
    }

    @Override
    public String getEncryptionKeyPairName() {
        return this.readProperty(KEY_ENCRYPTION_KEYPAIR);
    }

    @Override
    public String getKeyStoreViewName() {
        return this.readProperty(KEY_KEYSTORE_VIEW);
    }

    @Override
    public String getTrustedCAsViewName() {
        return this.readProperty(KEY_TRUSTED_CA_VIEW, "TrustedCAs");
    }

    @Override
    public Certificate getCertificateForSignature() throws SAML2ConfigurationException {
        String viewName = this.getKeyStoreViewName();
        String entryName = this.getSigningKeyPairName();
        try {
            return SAML2KeystoreWrapper.getInstance().getCertificate(viewName, entryName);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain certificate for signature with name: " + entryName + " from view: " + viewName, e);
        }
    }

    public Certificate getSecondaryCertificateForSignature() throws SAML2ConfigurationException {
        String viewName = this.getKeyStoreViewName();
        String entryName = this.getSecondarySigningKeyPairName();
        try {
            return SAML2KeystoreWrapper.getInstance().getCertificate(viewName, entryName);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain secondary certificate for signature with name: " + entryName + " from view: " + viewName, e);
        }
    }

    @Override
    public PrivateKey getPrivateKeyForEncryption() throws SAML2ConfigurationException {
        String viewName = this.getKeyStoreViewName();
        String entryName = this.getEncryptionKeyPairName();
        try {
            return SAML2KeystoreWrapper.getInstance().getPrivateKey(viewName, entryName);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain private key for encryption with name: " + entryName + " from view: " + viewName, e);
        }
    }

    @Override
    public PrivateKey getPrivateKeyForSignature() throws SAML2ConfigurationException {
        String viewName = this.getKeyStoreViewName();
        String entryName = this.getSigningKeyPairName();
        try {
            return SAML2KeystoreWrapper.getInstance().getPrivateKey(viewName, entryName);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain private key for signature with name: " + entryName + " from view: " + viewName, e);
        }
    }

    public PrivateKey getSecondaryPrivateKeyForSignature() throws SAML2ConfigurationException {
        String viewName = this.getKeyStoreViewName();
        String entryName = this.getSecondarySigningKeyPairName();
        try {
            return SAML2KeystoreWrapper.getInstance().getPrivateKey(viewName, entryName);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain secondary private key for signature with name: " + entryName + " from view: " + viewName, e);
        }
    }

    @Override
    public PublicKey getPublicKeyForEncryption() throws SAML2ConfigurationException {
        Certificate cert = this.getCertificateForEncryption();
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    @Override
    public Certificate getCertificateForEncryption() throws SAML2ConfigurationException {
        String viewName = this.getKeyStoreViewName();
        String entryName = this.getEncryptionKeyPairName();
        try {
            Certificate cert = SAML2KeystoreWrapper.getInstance().getCertificate(viewName, entryName);
            return cert;
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain certificate for encryption with name: " + entryName + " from view: " + viewName, e);
        }
    }

    @Override
    public String getSigningKeyPairName() {
        return this.readProperty(KEY_SIGNING_KEYPAIR);
    }

    public String getSecondarySigningKeyPairName() {
        return this.readProperty(KEY_SECONDARY_SIGNING_KEYPAIR);
    }

    @Override
    public boolean isToIncludeCertInSignature() {
        return Boolean.parseBoolean(this.readProperty(KEY_INCLUDE_CERT_IN_SIGNATURE, "false"));
    }

    @Override
    public boolean isToSignMetadata() {
        return Boolean.parseBoolean(this.readProperty(KEY_SIGN_METADATA, "false"));
    }

    public boolean isToUseSecondaryKeysForMetadata() {
        return Boolean.parseBoolean(this.readProperty(KEY_USE_SECONDARY_KEYS_FOR_METADATA));
    }

    @Override
    public boolean issueSAPLogonTickets() {
        return Boolean.parseBoolean(this.readProperty(KEY_ISSUE_SAP_LOGON_TICKETS, "false"));
    }

    @Override
    public synchronized SAML2BackChannelSecurityPolicy getBackChannelSecurityPolicy() {
        if (this.backChannelSecurity == null) {
            this.backChannelSecurity = new SAML2BackChannelSecurityPolicyImpl(this);
        }
        return this.backChannelSecurity;
    }

    @Override
    public synchronized SAML2MetadataSettings getMetadataSettings() {
        if (this.metadataSettings == null) {
            this.metadataSettings = new SAML2MetadataSettingsImpl(this);
        }
        return this.metadataSettings;
    }

    @Override
    public Collection<SAML2CfgAuthenticationContext> getAuthenticationContexts() {
        return this.readAuthnContexts();
    }

    @Override
    public synchronized SAML2CfgAuthenticationContext getAuthenticationContextByName(String name) {
        if (this.authneticationContextsByName == null) {
            this.readAuthnContexts();
        }
        return this.authneticationContextsByName.get(name);
    }

    @Override
    public synchronized SAML2CfgAuthenticationContext getAuthenticationContextByAlias(String alias) {
        if (alias == null) {
            return null;
        }
        if (this.authneticationContextsByAlias == null) {
            this.readAuthnContexts();
        }
        String aliasLowerCase = alias.toLowerCase(Locale.ENGLISH);
        return this.authneticationContextsByAlias.get(aliasLowerCase);
    }

    @Override
    public Collection<SAML2CfgUMEAttribute> getUMEAttributes() {
        return this.readUMEAttributes();
    }

    @Override
    public synchronized SAML2CfgUMEAttribute getUMEAttributeByAlias(String alias) {
        if (alias == null) {
            return null;
        }
        if (this.umeAttributesByAlias == null) {
            this.readUMEAttributes();
        }
        return this.umeAttributesByAlias.get(alias);
    }

    public SAML2CfgUMEAttribute getUMEAttribute(String name, String namespace) {
        if (name == null) {
            return null;
        }
        if (CfgUtils.isEmpty(namespace)) {
            namespace = "com.sap.security.core.usermanagement";
        }
        Collection<SAML2CfgUMEAttribute> umeAttributes = this.getUMEAttributes();
        for (SAML2CfgUMEAttribute umeAttribute : umeAttributes) {
            String umeAttributeName = umeAttribute.getName();
            String umeAttributeNamespace = umeAttribute.getNamespace();
            if (CfgUtils.isEmpty(umeAttributeNamespace)) {
                umeAttributeNamespace = "com.sap.security.core.usermanagement";
            }
            if (!name.equals(umeAttributeName) || !namespace.equals(umeAttributeNamespace)) continue;
            return umeAttribute;
        }
        return null;
    }

    @Override
    public boolean isPlainHTTPConnectionsEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_PLAIN_HTTP_ENABLED));
    }

    @Override
    public String getCustomLogonPageAlias() {
        return this.readProperty(KEY_CUSTOM_LOGON_PAGE_ALIAS);
    }

    @Override
    public int getIssueInstantValidityNotBeforeInMinutes() {
        return this.readIntProperty(KEY_ISSUE_INSTANT_VALIDITY_NOT_BEFORE, 5);
    }

    @Override
    public int getIssueInstantValidityNotAfterInMinutes() {
        return this.readIntProperty(KEY_ISSUE_INSTANT_VALIDITY_NOT_AFTER, 10);
    }

    @Override
    public SAML2ModifiableLocalProvider getModifiableLocalProvider() throws SAML2ConfigurationException {
        return new SAML2ModifiableLocalProviderImpl(this);
    }

    @Override
    protected synchronized void cleanCachedObjects() {
        this.backChannelSecurity = null;
        this.metadataSettings = null;
        this.authneticationContextsByName = null;
        this.authneticationContextsByAlias = null;
        this.umeAttributesByAlias = null;
        this.redirectApplicationConfiguration = null;
    }

    private synchronized Collection<SAML2CfgAuthenticationContext> readAuthnContexts() {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.authneticationContextsByName != null) {
            return this.authneticationContextsByName.values();
        }
        this.authneticationContextsByName = new HashMap<String, SAML2CfgAuthenticationContext>();
        this.authneticationContextsByAlias = new HashMap<String, SAML2CfgAuthenticationContext>();
        String[] authnContextSheets = null;
        try {
            authnContextSheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_AUTHENTICATION_CONTEXTS);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load authentication contexts configuration", (Throwable)e);
        }
        if (authnContextSheets != null) {
            String[] stringArray = authnContextSheets;
            int n = authnContextSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String authnContextSheet = stringArray[n2];
                SAML2CfgAuthenticationContextImpl authnContext = new SAML2CfgAuthenticationContextImpl(this, CFG_SUB_PATH_AUTHENTICATION_CONTEXTS, authnContextSheet);
                String name = authnContext.getName();
                if (name != null && name.length() > 0) {
                    this.authneticationContextsByName.put(name, authnContext);
                } else if (LOCATION.beWarning()) {
                    LOCATION.warningT("The configured authentication context does not have name. Authentication context: {0}", new Object[]{authnContext});
                }
                String alias = authnContext.getAlias();
                if (alias != null && alias.length() > 0) {
                    this.authneticationContextsByAlias.put(alias.toLowerCase(Locale.ENGLISH), authnContext);
                } else if (LOCATION.beWarning()) {
                    LOCATION.warningT("The configured authentication context does not have alias. Authentication context: {0}", new Object[]{authnContext});
                }
                ++n2;
            }
        }
        return this.authneticationContextsByName.values();
    }

    private synchronized Collection<SAML2CfgUMEAttribute> readUMEAttributes() {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.umeAttributesByAlias != null) {
            return this.umeAttributesByAlias.values();
        }
        this.umeAttributesByAlias = new HashMap<String, SAML2CfgUMEAttribute>();
        String[] umeAttributeSheets = null;
        try {
            umeAttributeSheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_UME_ATTRIBUTES);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load predefined ume attributes configuration", (Throwable)e);
        }
        if (umeAttributeSheets != null) {
            String[] stringArray = umeAttributeSheets;
            int n = umeAttributeSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String umeAttributeSheet = stringArray[n2];
                SAML2CfgUMEAttributeImpl umeAttribute = new SAML2CfgUMEAttributeImpl(this, CFG_SUB_PATH_UME_ATTRIBUTES, umeAttributeSheet);
                String alias = umeAttribute.getAlias();
                if (alias != null && alias.length() > 0) {
                    this.umeAttributesByAlias.put(alias, umeAttribute);
                } else if (LOCATION.beWarning()) {
                    LOCATION.warningT("The configured ume attribute does not have alias. UME attribute: {0}", new Object[]{umeAttribute});
                }
                ++n2;
            }
        }
        return this.umeAttributesByAlias.values();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nLocal provider cfg path: ").append(super.toString());
        builder.append("\nName: ").append(this.getName());
        builder.append("\nId: ").append(SAML2Utils.byteArrayToHEXString((byte[])this.getID()));
        builder.append("\nKeystore view: ").append(this.getKeyStoreViewName());
        builder.append("\nTrusted CAs keystore view: ").append(this.getTrustedCAsViewName());
        builder.append("\nSigning keypair: ").append(this.getSigningKeyPairName());
        builder.append("\nEncryption keypair: ").append(this.getEncryptionKeyPairName());
        builder.append("\nInclude certificate in signature: ").append(this.isToIncludeCertInSignature());
        builder.append("\nARS suported bindings: ").append(this.getArtifactResolutionSupportedBindings());
        builder.append("\nArtifact validity period: ").append(this.getArtifactValidityPeriodInSeconds());
        builder.append("\nBack-channel security policy: ").append(this.getBackChannelSecurityPolicy());
        builder.append("\nMetadata settings: ").append(this.getMetadataSettings());
        builder.append("\nSign metadata: ").append(this.isToSignMetadata());
        builder.append("\nIssueInstant validity not before period: ").append(this.getIssueInstantValidityNotBeforeInMinutes());
        builder.append("\nIssueInstant validity not after period: ").append(this.getIssueInstantValidityNotAfterInMinutes());
        builder.append("\nClock skew tolerance: ").append(this.getClockSkewToleranceInSeconds());
        builder.append("\nCustom logon page alias: ").append(this.getCustomLogonPageAlias());
        builder.append("\nIssue Logon ticket: ").append(this.issueSAPLogonTickets());
        builder.append("\nPlain HTTP connections allowed: ").append(this.isPlainHTTPConnectionsEnabled());
        builder.append("\nCustom UME attributes: ").append(this.getCustomUMEAttributesForTrace());
        builder.append("\nCustom authentication contexts: ").append(this.getCustomAuthnContextsForTrace());
        builder.append("\n").append(this.getRedirectApplicationConfiguration());
        builder.append("\n");
        return builder.toString();
    }

    private String getCustomAuthnContextsForTrace() {
        StringBuilder builder = new StringBuilder();
        Collection<SAML2CfgAuthenticationContext> authnContexts = this.getAuthenticationContexts();
        for (SAML2CfgAuthenticationContext authnContext : authnContexts) {
            if (!authnContext.isCustom()) continue;
            builder.append("\n  ").append(authnContext);
        }
        return builder.toString();
    }

    private String getCustomUMEAttributesForTrace() {
        StringBuilder builder = new StringBuilder();
        Collection<SAML2CfgUMEAttribute> umeAttributes = this.getUMEAttributes();
        for (SAML2CfgUMEAttribute umeAttribute : umeAttributes) {
            if (!umeAttribute.isCustom()) continue;
            builder.append("\n  ").append(umeAttribute);
        }
        return builder.toString();
    }

    @Override
    public SAML2RedirectApplicationConfiguration getRedirectApplicationConfiguration() {
        if (this.redirectApplicationConfiguration == null) {
            this.redirectApplicationConfiguration = new SAML2RedirectApplicationConfigurationImpl(this);
        }
        return this.redirectApplicationConfiguration;
    }
}

