/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgFactory;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2ConfigImpl;
import com.sap.security.saml2.cfg.SAML2KeystoreWrapper;
import com.sap.security.saml2.cfg.SAML2LocalIdPImpl;
import com.sap.security.saml2.cfg.SAML2LocalProviderImpl;
import com.sap.security.saml2.cfg.SAML2LocalSPImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableProviderBase;
import com.sap.security.saml2.cfg.enums.SAML2MetadataMode;
import com.sap.security.saml2.cfg.enums.SAML2OperationalMode;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2LocalProvidersConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2GlobalSettings;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.metadata.SAML2EndpointURL;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataGenerator;
import com.sap.security.saml2.cfg.security.SAML2CfgSecurityManager;
import com.sap.security.saml2.cfg.storage.CfgChangeEvent;
import com.sap.security.saml2.cfg.storage.CfgPropertySetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.storage.StorageChangedListener;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class SAML2LocalProvidersConfigImpl
extends SAML2CfgObject
implements SAML2LocalProvidersConfig,
StorageChangedListener {
    private static final long serialVersionUID = 1L;
    private static final String CFG_NODE_LOCAL_PROVIDERS_REL_PATH = "/local_providers";
    private static final String CFG_PROPERTY_SHEET = "state";
    private static final Location LOCATION = Location.getLocation(SAML2LocalProvidersConfigImpl.class);
    private static final String CFG_SUB_PATH_COMMON = "common";
    private static final String CFG_SUB_PATH_SP = "sp";
    private static final String CFG_SUB_PATH_IDP = "idp";
    private Map<String, SAML2UpdateableProviderBase> updateableObjects = new HashMap<String, SAML2UpdateableProviderBase>();
    private SAML2ConfigImpl parent;
    private SAML2LocalProviderImpl localProviderCommon;
    private SAML2LocalIdPImpl localIdP;
    private SAML2LocalSPImpl localSP;
    private static final String KEY_IS_SAML2_FUNCTIONALITY_ENABLED = "is_saml2_functionality_enabled";
    private static final String KEY_OPERATIONAL_MODE = "operational_mode";
    private SAML2OperationalMode operationalMode;
    private Boolean isSAML2FunctionalityEnabled;

    public SAML2LocalProvidersConfigImpl(SAML2ConfigImpl parent) throws SAML2ConfigurationException {
        super(String.valueOf(parent.getCfgPath()) + CFG_NODE_LOCAL_PROVIDERS_REL_PATH, CFG_PROPERTY_SHEET, false);
        this.parent = parent;
        try {
            this.registerAsStorageListener(this);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not register storage listener for local SAML2 providers with path: {0}", new Object[]{this.getCfgPath()}, (Throwable)e);
        }
        String localProviderCommonPath = String.valueOf(this.getCfgPath()) + "/" + CFG_SUB_PATH_COMMON;
        this.localProviderCommon = new SAML2LocalProviderImpl(localProviderCommonPath);
        this.updateableObjects.put(localProviderCommonPath, this.localProviderCommon);
        String localSPPath = String.valueOf(this.getCfgPath()) + "/" + CFG_SUB_PATH_SP;
        this.localSP = new SAML2LocalSPImpl(localSPPath, this.localProviderCommon);
        this.updateableObjects.put(localSPPath, this.localSP);
        String localIdPPath = String.valueOf(this.getCfgPath()) + "/" + CFG_SUB_PATH_IDP;
        this.localIdP = new SAML2LocalIdPImpl(localIdPPath, this.localProviderCommon);
        this.updateableObjects.put(localIdPPath, this.localIdP);
    }

    @Override
    public SAML2LocalProvider getLocalProvider() {
        return this.localProviderCommon;
    }

    @Override
    public SAML2LocalIdP getLocalIdP() {
        return this.localIdP;
    }

    @Override
    public SAML2LocalSP getLocalSP() {
        return this.localSP;
    }

    @Override
    public void storageChanged(CfgChangeEvent event) {
        CfgChangeEvent lastEvent;
        String lastEventPath;
        String pathToModifiedConfiguration;
        CfgChangeEvent[] detailedEvents = event.getDetailedChangeEvents();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received detailed change events: {0}", new Object[]{Arrays.asList(detailedEvents)});
        }
        if ((pathToModifiedConfiguration = CfgUtils.extractRelativePathToFirstSubNode(lastEventPath = (lastEvent = detailedEvents[detailedEvents.length - 1]).getPath(), this.getCfgPath())) != null) {
            if (pathToModifiedConfiguration.endsWith(CFG_PROPERTY_SHEET)) {
                this.cleanCachedObjects();
            } else {
                SAML2UpdateableProviderBase updateableObject = this.updateableObjects.get(pathToModifiedConfiguration);
                if (updateableObject != null) {
                    updateableObject.update();
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("There is not local provider to update with path: {0}", new Object[]{pathToModifiedConfiguration});
                }
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("Path: {0} of the received event does not corresponds to the path for this listener: {1}", new Object[]{lastEventPath, this.getCfgPath()});
        }
    }

    private synchronized void cleanCachedObjects() {
        this.isSAML2FunctionalityEnabled = null;
        this.operationalMode = null;
    }

    @Override
    public boolean isSAML2FunctionalityEnabled() {
        return this.readSAML2FunctionalityEnabled();
    }

    @Override
    public boolean isIdentityProviderEnabled() {
        if (!this.isSAML2FunctionalityEnabled()) {
            return false;
        }
        SAML2OperationalMode mode = this.getOperationalMode();
        return mode == SAML2OperationalMode.IDENTITY_PROVIDER || mode == SAML2OperationalMode.IDENTITY_AND_SERVICE_PROVIDERS;
    }

    @Override
    public boolean isServiceProviderEnabled() {
        if (!this.isSAML2FunctionalityEnabled()) {
            return false;
        }
        SAML2OperationalMode mode = this.getOperationalMode();
        return mode == SAML2OperationalMode.SERVICE_PROVIDER || mode == SAML2OperationalMode.IDENTITY_AND_SERVICE_PROVIDERS;
    }

    @Override
    public SAML2OperationalMode getOperationalMode() {
        int controlFlag;
        SAML2OperationalMode dbOperationalMode;
        block4: {
            dbOperationalMode = this.readOperationalMode();
            controlFlag = CfgConstants.DEFAULT_CONTROL_FLAG;
            try {
                SAML2GlobalSettings globalSettings = SAML2CfgFactory.getSAML2GlobalConfig().getGlobalSettings();
                controlFlag = globalSettings.getControlFlag();
            }
            catch (SAML2ConfigurationException e) {
                if (!LOCATION.beWarning()) break block4;
                LOCATION.traceThrowableT(400, "Could not read SAML2 global settings", (Throwable)e);
            }
        }
        if (controlFlag == 0 && dbOperationalMode != null) {
            SAML2OperationalMode result = SAML2OperationalMode.SERVICE_PROVIDER;
            if (LOCATION.beDebug() && dbOperationalMode != result) {
                LOCATION.debugT("According to the control flag: {0}, return operational mode: {1}, instead of the configured: {2}", new Object[]{controlFlag, result, dbOperationalMode});
            }
            return result;
        }
        return dbOperationalMode;
    }

    @Override
    public String obtainMetadata(SAML2EndpointURL url, SAML2MetadataMode mode) throws SAML2ConfigurationException {
        return this.obtainMetadata(url, (String)null, (String)null, mode);
    }

    @Override
    public String obtainMetadata(SAML2EndpointURL url, String viewName, String entryName, SAML2MetadataMode mode) throws SAML2ConfigurationException {
        PrivateKey privateKey = null;
        Certificate certificate = null;
        SAML2LocalProvider localProvider = this.getLocalProvider();
        boolean signMetadata = localProvider.isToSignMetadata();
        if (signMetadata) {
            if (CfgUtils.isEmpty(viewName) || CfgUtils.isEmpty(entryName)) {
                viewName = localProvider.getKeyStoreViewName();
                entryName = localProvider.getSigningKeyPairName();
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Given view or entry name is empty. Therefore read them from the configuration - view name: [{0}], entry name: [{1}]", new Object[]{viewName, entryName});
                }
                if (CfgUtils.isEmpty(viewName)) {
                    throw new SAML2ConfigurationException("Could not generate signed SAML2 metadata, because there is not configured keystore view");
                }
                if (CfgUtils.isEmpty(entryName)) {
                    throw new SAML2ConfigurationException("Could not generate signed SAML2 metadata, because there is not configured keypair for signature");
                }
            }
            try {
                privateKey = SAML2KeystoreWrapper.getInstance().getPrivateKey(viewName, entryName);
                certificate = SAML2KeystoreWrapper.getInstance().getCertificate(viewName, entryName);
            }
            catch (Exception e) {
                throw new SAML2ConfigurationException("Could not read keystore entry: " + entryName + " from view: " + viewName, e);
            }
        }
        return this.obtainMetadata(url, privateKey, certificate, mode);
    }

    @Override
    public String obtainMetadata(SAML2EndpointURL url, PrivateKey privateKey, Certificate certificate, SAML2MetadataMode mode) throws SAML2ConfigurationException {
        return SAML2MetadataGenerator.getInstance().generateMetadata(this, url, privateKey, certificate, mode);
    }

    @Override
    public synchronized void setOperationalMode(SAML2OperationalMode mode) throws SAML2ConfigurationException {
        SAML2CfgSecurityManager.getInstance().checkWritePermission();
        SAML2OperationalMode changeLogOldValue = this.getOperationalMode();
        if (mode != null) {
            try {
                CfgPropertySetter propertySetter = this.getPropertySetter();
                propertySetter.setProperty(KEY_OPERATIONAL_MODE, mode.name());
                this.write(propertySetter);
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("SAML2 operational mode is changed to: {0}", new Object[]{mode});
                }
            }
            catch (Exception e) {
                throw new SAML2ConfigurationException("Could not write SAML2 operational mode", e);
            }
            this.cleanCachedObjects();
            SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001001", (String)"Property [SAML2 operational mode] was changed. Old version: [{0}], new version: [{1}].", (Object[])new Object[]{changeLogOldValue, this.getOperationalMode()});
        }
    }

    @Override
    public void setSAML2FunctionalityEnabled(Boolean isEnabled) throws SAML2ConfigurationException {
        SAML2CfgSecurityManager.getInstance().checkWritePermission();
        Boolean changeLogOldValue = this.isSAML2FunctionalityEnabled();
        try {
            CfgPropertySetter propertySetter = this.getPropertySetter();
            propertySetter.setProperty(KEY_IS_SAML2_FUNCTIONALITY_ENABLED, isEnabled != null ? "" + isEnabled : null);
            this.write(propertySetter);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("SAML2 functionality enabled is changed to: {0}", new Object[]{isEnabled});
            }
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not write SAML2 functionality enabled property", e);
        }
        this.cleanCachedObjects();
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001000", (String)"Property [SAML2 functionality enabled] was changed. Old version: [{0}], new version: [{1}].", (Object[])new Object[]{changeLogOldValue, this.isSAML2FunctionalityEnabled()});
    }

    public boolean isDefaultSAML2Configuration() {
        return this.getParent().isDefaultSAML2Config();
    }

    void destroy() {
        try {
            this.unregisterAsStorageListener(this);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not unregister storage listener for local SAML2 providers with path: {0}", new Object[]{this.getCfgPath()}, (Throwable)e);
        }
    }

    protected SAML2ConfigImpl getParent() {
        return this.parent;
    }

    private synchronized SAML2OperationalMode readOperationalMode() {
        SAML2OperationalMode result = CfgConstants.DEFAULT_SAML2_OPERATIONAL_MODE;
        if (this.operationalMode == null) {
            SAML2OperationalMode mode;
            String operationalModeName = this.getPropertyValue(KEY_OPERATIONAL_MODE, null).getValue();
            if (operationalModeName != null && operationalModeName.length() > 0 && (mode = SAML2OperationalMode.valueOf(operationalModeName)) != null) {
                result = mode;
                this.operationalMode = mode;
            }
        } else {
            result = this.operationalMode;
        }
        return result;
    }

    private synchronized Boolean readSAML2FunctionalityEnabled() {
        Boolean result = Boolean.FALSE;
        if (this.isSAML2FunctionalityEnabled == null) {
            String saml2FunctionalityEnabled = this.getPropertyValue(KEY_IS_SAML2_FUNCTIONALITY_ENABLED, null).getValue();
            if (saml2FunctionalityEnabled != null && saml2FunctionalityEnabled.length() > 0) {
                this.isSAML2FunctionalityEnabled = result = Boolean.valueOf(saml2FunctionalityEnabled);
            }
        } else {
            result = this.isSAML2FunctionalityEnabled;
        }
        return result;
    }
}

